<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterPickupPoint StructType
 * @subpackage Structs
 */
class RegisterPickupPoint extends AbstractStructBase
{
    /**
     * The pickupPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: s1:pickupPoint
     * @var \StructType\PickupPoint
     */
    public $pickupPoint;
    /**
     * The settingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $settingId;
    /**
     * The accessKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accessKey;
    /**
     * Constructor method for RegisterPickupPoint
     * @uses RegisterPickupPoint::setPickupPoint()
     * @uses RegisterPickupPoint::setSettingId()
     * @uses RegisterPickupPoint::setAccessKey()
     * @param \StructType\PickupPoint $pickupPoint
     * @param int $settingId
     * @param string $accessKey
     */
    public function __construct(\StructType\PickupPoint $pickupPoint = null, $settingId = null, $accessKey = null)
    {
        $this
            ->setPickupPoint($pickupPoint)
            ->setSettingId($settingId)
            ->setAccessKey($accessKey);
    }
    /**
     * Get pickupPoint value
     * @return \StructType\PickupPoint
     */
    public function getPickupPoint()
    {
        return $this->pickupPoint;
    }
    /**
     * Set pickupPoint value
     * @param \StructType\PickupPoint $pickupPoint
     * @return \StructType\RegisterPickupPoint
     */
    public function setPickupPoint(\StructType\PickupPoint $pickupPoint = null)
    {
        $this->pickupPoint = $pickupPoint;
        return $this;
    }
    /**
     * Get settingId value
     * @return int
     */
    public function getSettingId()
    {
        return $this->settingId;
    }
    /**
     * Set settingId value
     * @param int $settingId
     * @return \StructType\RegisterPickupPoint
     */
    public function setSettingId($settingId = null)
    {
        // validation for constraint: int
        if (!is_null($settingId) && !(is_int($settingId) || ctype_digit($settingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($settingId, true), gettype($settingId)), __LINE__);
        }
        $this->settingId = $settingId;
        return $this;
    }
    /**
     * Get accessKey value
     * @return string|null
     */
    public function getAccessKey()
    {
        return $this->accessKey;
    }
    /**
     * Set accessKey value
     * @param string $accessKey
     * @return \StructType\RegisterPickupPoint
     */
    public function setAccessKey($accessKey = null)
    {
        // validation for constraint: string
        if (!is_null($accessKey) && !is_string($accessKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessKey, true), gettype($accessKey)), __LINE__);
        }
        $this->accessKey = $accessKey;
        return $this;
    }
}
