<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for commonResponse StructType
 * @subpackage Structs
 */
class CommonResponse extends AbstractStructBase
{
    /**
     * The isError
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isError;
    /**
     * The errorText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorText;
    /**
     * The idObject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idObject;
    /**
     * Constructor method for commonResponse
     * @uses CommonResponse::setIsError()
     * @uses CommonResponse::setErrorText()
     * @uses CommonResponse::setIdObject()
     * @param bool $isError
     * @param string $errorText
     * @param string $idObject
     */
    public function __construct($isError = null, $errorText = null, $idObject = null)
    {
        $this
            ->setIsError($isError)
            ->setErrorText($errorText)
            ->setIdObject($idObject);
    }
    /**
     * Get isError value
     * @return bool
     */
    public function getIsError()
    {
        return $this->isError;
    }
    /**
     * Set isError value
     * @param bool $isError
     * @return \StructType\CommonResponse
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isError, true), gettype($isError)), __LINE__);
        }
        $this->isError = $isError;
        return $this;
    }
    /**
     * Get errorText value
     * @return string|null
     */
    public function getErrorText()
    {
        return $this->errorText;
    }
    /**
     * Set errorText value
     * @param string $errorText
     * @return \StructType\CommonResponse
     */
    public function setErrorText($errorText = null)
    {
        // validation for constraint: string
        if (!is_null($errorText) && !is_string($errorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorText, true), gettype($errorText)), __LINE__);
        }
        $this->errorText = $errorText;
        return $this;
    }
    /**
     * Get idObject value
     * @return string|null
     */
    public function getIdObject()
    {
        return $this->idObject;
    }
    /**
     * Set idObject value
     * @param string $idObject
     * @return \StructType\CommonResponse
     */
    public function setIdObject($idObject = null)
    {
        // validation for constraint: string
        if (!is_null($idObject) && !is_string($idObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idObject, true), gettype($idObject)), __LINE__);
        }
        $this->idObject = $idObject;
        return $this;
    }
}
