<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddLogo StructType
 * @subpackage Structs
 */
class AddLogo extends AbstractStructBase
{
    /**
     * The internetShopID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $internetShopID;
    /**
     * The logoType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $logoType;
    /**
     * The logo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $logo;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for AddLogo
     * @uses AddLogo::setInternetShopID()
     * @uses AddLogo::setLogoType()
     * @uses AddLogo::setLogo()
     * @uses AddLogo::setAuth()
     * @param int $internetShopID
     * @param int $logoType
     * @param string $logo
     * @param \StructType\Authentication $auth
     */
    public function __construct($internetShopID = null, $logoType = null, $logo = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setInternetShopID($internetShopID)
            ->setLogoType($logoType)
            ->setLogo($logo)
            ->setAuth($auth);
    }
    /**
     * Get internetShopID value
     * @return int
     */
    public function getInternetShopID()
    {
        return $this->internetShopID;
    }
    /**
     * Set internetShopID value
     * @param int $internetShopID
     * @return \StructType\AddLogo
     */
    public function setInternetShopID($internetShopID = null)
    {
        // validation for constraint: int
        if (!is_null($internetShopID) && !(is_int($internetShopID) || ctype_digit($internetShopID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internetShopID, true), gettype($internetShopID)), __LINE__);
        }
        $this->internetShopID = $internetShopID;
        return $this;
    }
    /**
     * Get logoType value
     * @return int
     */
    public function getLogoType()
    {
        return $this->logoType;
    }
    /**
     * Set logoType value
     * @param int $logoType
     * @return \StructType\AddLogo
     */
    public function setLogoType($logoType = null)
    {
        // validation for constraint: int
        if (!is_null($logoType) && !(is_int($logoType) || ctype_digit($logoType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logoType, true), gettype($logoType)), __LINE__);
        }
        $this->logoType = $logoType;
        return $this;
    }
    /**
     * Get logo value
     * @return string|null
     */
    public function getLogo()
    {
        return $this->logo;
    }
    /**
     * Set logo value
     * @param string $logo
     * @return \StructType\AddLogo
     */
    public function setLogo($logo = null)
    {
        // validation for constraint: string
        if (!is_null($logo) && !is_string($logo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logo, true), gettype($logo)), __LINE__);
        }
        $this->logo = $logo;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\AddLogo
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
