<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Terminal StructType
 * @subpackage Structs
 */
class Terminal extends AbstractStructBase
{
    /**
     * The TerminalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TerminalId;
    /**
     * The IsSelfDeliveryEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSelfDeliveryEnabled;
    /**
     * The IsCourierDeliveryEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCourierDeliveryEnabled;
    /**
     * The DeliveryDurationFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeliveryDurationFrom;
    /**
     * The DeliveryDurationTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeliveryDurationTo;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * Constructor method for Terminal
     * @uses Terminal::setTerminalId()
     * @uses Terminal::setIsSelfDeliveryEnabled()
     * @uses Terminal::setIsCourierDeliveryEnabled()
     * @uses Terminal::setDeliveryDurationFrom()
     * @uses Terminal::setDeliveryDurationTo()
     * @uses Terminal::setCode()
     * @uses Terminal::setCity()
     * @uses Terminal::setAddress()
     * @param int $terminalId
     * @param bool $isSelfDeliveryEnabled
     * @param bool $isCourierDeliveryEnabled
     * @param int $deliveryDurationFrom
     * @param int $deliveryDurationTo
     * @param string $code
     * @param string $city
     * @param string $address
     */
    public function __construct($terminalId = null, $isSelfDeliveryEnabled = null, $isCourierDeliveryEnabled = null, $deliveryDurationFrom = null, $deliveryDurationTo = null, $code = null, $city = null, $address = null)
    {
        $this
            ->setTerminalId($terminalId)
            ->setIsSelfDeliveryEnabled($isSelfDeliveryEnabled)
            ->setIsCourierDeliveryEnabled($isCourierDeliveryEnabled)
            ->setDeliveryDurationFrom($deliveryDurationFrom)
            ->setDeliveryDurationTo($deliveryDurationTo)
            ->setCode($code)
            ->setCity($city)
            ->setAddress($address);
    }
    /**
     * Get TerminalId value
     * @return int
     */
    public function getTerminalId()
    {
        return $this->TerminalId;
    }
    /**
     * Set TerminalId value
     * @param int $terminalId
     * @return \StructType\Terminal
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: int
        if (!is_null($terminalId) && !(is_int($terminalId) || ctype_digit($terminalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        $this->TerminalId = $terminalId;
        return $this;
    }
    /**
     * Get IsSelfDeliveryEnabled value
     * @return bool
     */
    public function getIsSelfDeliveryEnabled()
    {
        return $this->IsSelfDeliveryEnabled;
    }
    /**
     * Set IsSelfDeliveryEnabled value
     * @param bool $isSelfDeliveryEnabled
     * @return \StructType\Terminal
     */
    public function setIsSelfDeliveryEnabled($isSelfDeliveryEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelfDeliveryEnabled) && !is_bool($isSelfDeliveryEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelfDeliveryEnabled, true), gettype($isSelfDeliveryEnabled)), __LINE__);
        }
        $this->IsSelfDeliveryEnabled = $isSelfDeliveryEnabled;
        return $this;
    }
    /**
     * Get IsCourierDeliveryEnabled value
     * @return bool
     */
    public function getIsCourierDeliveryEnabled()
    {
        return $this->IsCourierDeliveryEnabled;
    }
    /**
     * Set IsCourierDeliveryEnabled value
     * @param bool $isCourierDeliveryEnabled
     * @return \StructType\Terminal
     */
    public function setIsCourierDeliveryEnabled($isCourierDeliveryEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCourierDeliveryEnabled) && !is_bool($isCourierDeliveryEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCourierDeliveryEnabled, true), gettype($isCourierDeliveryEnabled)), __LINE__);
        }
        $this->IsCourierDeliveryEnabled = $isCourierDeliveryEnabled;
        return $this;
    }
    /**
     * Get DeliveryDurationFrom value
     * @return int
     */
    public function getDeliveryDurationFrom()
    {
        return $this->DeliveryDurationFrom;
    }
    /**
     * Set DeliveryDurationFrom value
     * @param int $deliveryDurationFrom
     * @return \StructType\Terminal
     */
    public function setDeliveryDurationFrom($deliveryDurationFrom = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryDurationFrom) && !(is_int($deliveryDurationFrom) || ctype_digit($deliveryDurationFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryDurationFrom, true), gettype($deliveryDurationFrom)), __LINE__);
        }
        $this->DeliveryDurationFrom = $deliveryDurationFrom;
        return $this;
    }
    /**
     * Get DeliveryDurationTo value
     * @return int
     */
    public function getDeliveryDurationTo()
    {
        return $this->DeliveryDurationTo;
    }
    /**
     * Set DeliveryDurationTo value
     * @param int $deliveryDurationTo
     * @return \StructType\Terminal
     */
    public function setDeliveryDurationTo($deliveryDurationTo = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryDurationTo) && !(is_int($deliveryDurationTo) || ctype_digit($deliveryDurationTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryDurationTo, true), gettype($deliveryDurationTo)), __LINE__);
        }
        $this->DeliveryDurationTo = $deliveryDurationTo;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Terminal
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Terminal
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\Terminal
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
}
