<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderInform StructType
 * @subpackage Structs
 */
class OrderInform extends AbstractStructBase
{
    /**
     * The statusID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $statusID;
    /**
     * The finalStatusID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $finalStatusID;
    /**
     * The deliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $deliveryDate;
    /**
     * The TimeStamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TimeStamp;
    /**
     * The ProcessingTerminal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ProcessingTerminal;
    /**
     * The Initiator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Initiator;
    /**
     * The ReasonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ReasonId;
    /**
     * The statusName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $statusName;
    /**
     * The statusENGName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $statusENGName;
    /**
     * The ReasonRrefusal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonRrefusal;
    /**
     * The CarNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarNumber;
    /**
     * The DriverPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverPhone;
    /**
     * The finalStatusName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $finalStatusName;
    /**
     * The finalStatusENGName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $finalStatusENGName;
    /**
     * The ExtraOpts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraOpt
     */
    public $ExtraOpts;
    /**
     * The FullAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FullAddress;
    /**
     * Constructor method for OrderInform
     * @uses OrderInform::setStatusID()
     * @uses OrderInform::setFinalStatusID()
     * @uses OrderInform::setDeliveryDate()
     * @uses OrderInform::setTimeStamp()
     * @uses OrderInform::setProcessingTerminal()
     * @uses OrderInform::setInitiator()
     * @uses OrderInform::setReasonId()
     * @uses OrderInform::setStatusName()
     * @uses OrderInform::setStatusENGName()
     * @uses OrderInform::setReasonRrefusal()
     * @uses OrderInform::setCarNumber()
     * @uses OrderInform::setDriverPhone()
     * @uses OrderInform::setFinalStatusName()
     * @uses OrderInform::setFinalStatusENGName()
     * @uses OrderInform::setExtraOpts()
     * @uses OrderInform::setFullAddress()
     * @param int $statusID
     * @param int $finalStatusID
     * @param string $deliveryDate
     * @param string $timeStamp
     * @param int $processingTerminal
     * @param int $initiator
     * @param int $reasonId
     * @param string $statusName
     * @param string $statusENGName
     * @param string $reasonRrefusal
     * @param string $carNumber
     * @param string $driverPhone
     * @param string $finalStatusName
     * @param string $finalStatusENGName
     * @param \ArrayType\ArrayOfExtraOpt $extraOpts
     * @param string $fullAddress
     */
    public function __construct($statusID = null, $finalStatusID = null, $deliveryDate = null, $timeStamp = null, $processingTerminal = null, $initiator = null, $reasonId = null, $statusName = null, $statusENGName = null, $reasonRrefusal = null, $carNumber = null, $driverPhone = null, $finalStatusName = null, $finalStatusENGName = null, \ArrayType\ArrayOfExtraOpt $extraOpts = null, $fullAddress = null)
    {
        $this
            ->setStatusID($statusID)
            ->setFinalStatusID($finalStatusID)
            ->setDeliveryDate($deliveryDate)
            ->setTimeStamp($timeStamp)
            ->setProcessingTerminal($processingTerminal)
            ->setInitiator($initiator)
            ->setReasonId($reasonId)
            ->setStatusName($statusName)
            ->setStatusENGName($statusENGName)
            ->setReasonRrefusal($reasonRrefusal)
            ->setCarNumber($carNumber)
            ->setDriverPhone($driverPhone)
            ->setFinalStatusName($finalStatusName)
            ->setFinalStatusENGName($finalStatusENGName)
            ->setExtraOpts($extraOpts)
            ->setFullAddress($fullAddress);
    }
    /**
     * Get statusID value
     * @return int
     */
    public function getStatusID()
    {
        return $this->statusID;
    }
    /**
     * Set statusID value
     * @param int $statusID
     * @return \StructType\OrderInform
     */
    public function setStatusID($statusID = null)
    {
        // validation for constraint: int
        if (!is_null($statusID) && !(is_int($statusID) || ctype_digit($statusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusID, true), gettype($statusID)), __LINE__);
        }
        $this->statusID = $statusID;
        return $this;
    }
    /**
     * Get finalStatusID value
     * @return int
     */
    public function getFinalStatusID()
    {
        return $this->finalStatusID;
    }
    /**
     * Set finalStatusID value
     * @param int $finalStatusID
     * @return \StructType\OrderInform
     */
    public function setFinalStatusID($finalStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($finalStatusID) && !(is_int($finalStatusID) || ctype_digit($finalStatusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($finalStatusID, true), gettype($finalStatusID)), __LINE__);
        }
        $this->finalStatusID = $finalStatusID;
        return $this;
    }
    /**
     * Get deliveryDate value
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->deliveryDate;
    }
    /**
     * Set deliveryDate value
     * @param string $deliveryDate
     * @return \StructType\OrderInform
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->deliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OrderInform
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get ProcessingTerminal value
     * @return int
     */
    public function getProcessingTerminal()
    {
        return $this->ProcessingTerminal;
    }
    /**
     * Set ProcessingTerminal value
     * @param int $processingTerminal
     * @return \StructType\OrderInform
     */
    public function setProcessingTerminal($processingTerminal = null)
    {
        // validation for constraint: int
        if (!is_null($processingTerminal) && !(is_int($processingTerminal) || ctype_digit($processingTerminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processingTerminal, true), gettype($processingTerminal)), __LINE__);
        }
        $this->ProcessingTerminal = $processingTerminal;
        return $this;
    }
    /**
     * Get Initiator value
     * @return int
     */
    public function getInitiator()
    {
        return $this->Initiator;
    }
    /**
     * Set Initiator value
     * @param int $initiator
     * @return \StructType\OrderInform
     */
    public function setInitiator($initiator = null)
    {
        // validation for constraint: int
        if (!is_null($initiator) && !(is_int($initiator) || ctype_digit($initiator))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($initiator, true), gettype($initiator)), __LINE__);
        }
        $this->Initiator = $initiator;
        return $this;
    }
    /**
     * Get ReasonId value
     * @return int
     */
    public function getReasonId()
    {
        return $this->ReasonId;
    }
    /**
     * Set ReasonId value
     * @param int $reasonId
     * @return \StructType\OrderInform
     */
    public function setReasonId($reasonId = null)
    {
        // validation for constraint: int
        if (!is_null($reasonId) && !(is_int($reasonId) || ctype_digit($reasonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reasonId, true), gettype($reasonId)), __LINE__);
        }
        $this->ReasonId = $reasonId;
        return $this;
    }
    /**
     * Get statusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->statusName;
    }
    /**
     * Set statusName value
     * @param string $statusName
     * @return \StructType\OrderInform
     */
    public function setStatusName($statusName = null)
    {
        // validation for constraint: string
        if (!is_null($statusName) && !is_string($statusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusName, true), gettype($statusName)), __LINE__);
        }
        $this->statusName = $statusName;
        return $this;
    }
    /**
     * Get statusENGName value
     * @return string|null
     */
    public function getStatusENGName()
    {
        return $this->statusENGName;
    }
    /**
     * Set statusENGName value
     * @param string $statusENGName
     * @return \StructType\OrderInform
     */
    public function setStatusENGName($statusENGName = null)
    {
        // validation for constraint: string
        if (!is_null($statusENGName) && !is_string($statusENGName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusENGName, true), gettype($statusENGName)), __LINE__);
        }
        $this->statusENGName = $statusENGName;
        return $this;
    }
    /**
     * Get ReasonRrefusal value
     * @return string|null
     */
    public function getReasonRrefusal()
    {
        return $this->ReasonRrefusal;
    }
    /**
     * Set ReasonRrefusal value
     * @param string $reasonRrefusal
     * @return \StructType\OrderInform
     */
    public function setReasonRrefusal($reasonRrefusal = null)
    {
        // validation for constraint: string
        if (!is_null($reasonRrefusal) && !is_string($reasonRrefusal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonRrefusal, true), gettype($reasonRrefusal)), __LINE__);
        }
        $this->ReasonRrefusal = $reasonRrefusal;
        return $this;
    }
    /**
     * Get CarNumber value
     * @return string|null
     */
    public function getCarNumber()
    {
        return $this->CarNumber;
    }
    /**
     * Set CarNumber value
     * @param string $carNumber
     * @return \StructType\OrderInform
     */
    public function setCarNumber($carNumber = null)
    {
        // validation for constraint: string
        if (!is_null($carNumber) && !is_string($carNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carNumber, true), gettype($carNumber)), __LINE__);
        }
        $this->CarNumber = $carNumber;
        return $this;
    }
    /**
     * Get DriverPhone value
     * @return string|null
     */
    public function getDriverPhone()
    {
        return $this->DriverPhone;
    }
    /**
     * Set DriverPhone value
     * @param string $driverPhone
     * @return \StructType\OrderInform
     */
    public function setDriverPhone($driverPhone = null)
    {
        // validation for constraint: string
        if (!is_null($driverPhone) && !is_string($driverPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverPhone, true), gettype($driverPhone)), __LINE__);
        }
        $this->DriverPhone = $driverPhone;
        return $this;
    }
    /**
     * Get finalStatusName value
     * @return string|null
     */
    public function getFinalStatusName()
    {
        return $this->finalStatusName;
    }
    /**
     * Set finalStatusName value
     * @param string $finalStatusName
     * @return \StructType\OrderInform
     */
    public function setFinalStatusName($finalStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($finalStatusName) && !is_string($finalStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalStatusName, true), gettype($finalStatusName)), __LINE__);
        }
        $this->finalStatusName = $finalStatusName;
        return $this;
    }
    /**
     * Get finalStatusENGName value
     * @return string|null
     */
    public function getFinalStatusENGName()
    {
        return $this->finalStatusENGName;
    }
    /**
     * Set finalStatusENGName value
     * @param string $finalStatusENGName
     * @return \StructType\OrderInform
     */
    public function setFinalStatusENGName($finalStatusENGName = null)
    {
        // validation for constraint: string
        if (!is_null($finalStatusENGName) && !is_string($finalStatusENGName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalStatusENGName, true), gettype($finalStatusENGName)), __LINE__);
        }
        $this->finalStatusENGName = $finalStatusENGName;
        return $this;
    }
    /**
     * Get ExtraOpts value
     * @return \ArrayType\ArrayOfExtraOpt|null
     */
    public function getExtraOpts()
    {
        return $this->ExtraOpts;
    }
    /**
     * Set ExtraOpts value
     * @param \ArrayType\ArrayOfExtraOpt $extraOpts
     * @return \StructType\OrderInform
     */
    public function setExtraOpts(\ArrayType\ArrayOfExtraOpt $extraOpts = null)
    {
        $this->ExtraOpts = $extraOpts;
        return $this;
    }
    /**
     * Get FullAddress value
     * @return string|null
     */
    public function getFullAddress()
    {
        return $this->FullAddress;
    }
    /**
     * Set FullAddress value
     * @param string $fullAddress
     * @return \StructType\OrderInform
     */
    public function setFullAddress($fullAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fullAddress) && !is_string($fullAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullAddress, true), gettype($fullAddress)), __LINE__);
        }
        $this->FullAddress = $fullAddress;
        return $this;
    }
}
