<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderGroup StructType
 * @subpackage Structs
 */
class OrderGroup extends AbstractStructBase
{
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderId;
    /**
     * The Statuses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderStatuses
     */
    public $Statuses;
    /**
     * The ExtraOpts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraOpt
     */
    public $ExtraOpts;
    /**
     * Constructor method for OrderGroup
     * @uses OrderGroup::setOrderId()
     * @uses OrderGroup::setStatuses()
     * @uses OrderGroup::setExtraOpts()
     * @param int $orderId
     * @param \ArrayType\ArrayOfOrderStatuses $statuses
     * @param \ArrayType\ArrayOfExtraOpt $extraOpts
     */
    public function __construct($orderId = null, \ArrayType\ArrayOfOrderStatuses $statuses = null, \ArrayType\ArrayOfExtraOpt $extraOpts = null)
    {
        $this
            ->setOrderId($orderId)
            ->setStatuses($statuses)
            ->setExtraOpts($extraOpts);
    }
    /**
     * Get OrderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param int $orderId
     * @return \StructType\OrderGroup
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get Statuses value
     * @return \ArrayType\ArrayOfOrderStatuses|null
     */
    public function getStatuses()
    {
        return $this->Statuses;
    }
    /**
     * Set Statuses value
     * @param \ArrayType\ArrayOfOrderStatuses $statuses
     * @return \StructType\OrderGroup
     */
    public function setStatuses(\ArrayType\ArrayOfOrderStatuses $statuses = null)
    {
        $this->Statuses = $statuses;
        return $this;
    }
    /**
     * Get ExtraOpts value
     * @return \ArrayType\ArrayOfExtraOpt|null
     */
    public function getExtraOpts()
    {
        return $this->ExtraOpts;
    }
    /**
     * Set ExtraOpts value
     * @param \ArrayType\ArrayOfExtraOpt $extraOpts
     * @return \StructType\OrderGroup
     */
    public function setExtraOpts(\ArrayType\ArrayOfExtraOpt $extraOpts = null)
    {
        $this->ExtraOpts = $extraOpts;
        return $this;
    }
}
