<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConfirmOrderPackaging StructType
 * @subpackage Structs
 */
class ConfirmOrderPackaging extends AbstractStructBase
{
    /**
     * The orderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderID;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for ConfirmOrderPackaging
     * @uses ConfirmOrderPackaging::setOrderID()
     * @uses ConfirmOrderPackaging::setAuth()
     * @param int $orderID
     * @param \StructType\Authentication $auth
     */
    public function __construct($orderID = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setOrderID($orderID)
            ->setAuth($auth);
    }
    /**
     * Get orderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->orderID;
    }
    /**
     * Set orderID value
     * @param int $orderID
     * @return \StructType\ConfirmOrderPackaging
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->orderID = $orderID;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\ConfirmOrderPackaging
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
