<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImpUser StructType
 * @subpackage Structs
 */
class ImpUser extends AbstractStructBase
{
    /**
     * The userID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $userID;
    /**
     * The createDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $createDate;
    /**
     * The modifyDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $modifyDate;
    /**
     * The internetShopID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $internetShopID;
    /**
     * The AddNewAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AddNewAddress;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The userTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userTel;
    /**
     * The cardNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardNo;
    /**
     * The jurPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $jurPerson;
    /**
     * The jurAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $jurAddress;
    /**
     * The INN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $INN;
    /**
     * The KPP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KPP;
    /**
     * The OKPO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OKPO;
    /**
     * The RS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RS;
    /**
     * The KS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KS;
    /**
     * The userHomePhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHomePhone;
    /**
     * The UserAddresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfImpUserAddress
     */
    public $UserAddresses;
    /**
     * The FIO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FIO;
    /**
     * Constructor method for ImpUser
     * @uses ImpUser::setUserID()
     * @uses ImpUser::setCreateDate()
     * @uses ImpUser::setModifyDate()
     * @uses ImpUser::setInternetShopID()
     * @uses ImpUser::setAddNewAddress()
     * @uses ImpUser::setEmail()
     * @uses ImpUser::setUserTel()
     * @uses ImpUser::setCardNo()
     * @uses ImpUser::setJurPerson()
     * @uses ImpUser::setJurAddress()
     * @uses ImpUser::setINN()
     * @uses ImpUser::setKPP()
     * @uses ImpUser::setOKPO()
     * @uses ImpUser::setRS()
     * @uses ImpUser::setKS()
     * @uses ImpUser::setUserHomePhone()
     * @uses ImpUser::setUserAddresses()
     * @uses ImpUser::setFIO()
     * @param int $userID
     * @param string $createDate
     * @param string $modifyDate
     * @param int $internetShopID
     * @param bool $addNewAddress
     * @param string $email
     * @param string $userTel
     * @param string $cardNo
     * @param string $jurPerson
     * @param string $jurAddress
     * @param string $iNN
     * @param string $kPP
     * @param string $oKPO
     * @param string $rS
     * @param string $kS
     * @param string $userHomePhone
     * @param \ArrayType\ArrayOfImpUserAddress $userAddresses
     * @param string $fIO
     */
    public function __construct($userID = null, $createDate = null, $modifyDate = null, $internetShopID = null, $addNewAddress = null, $email = null, $userTel = null, $cardNo = null, $jurPerson = null, $jurAddress = null, $iNN = null, $kPP = null, $oKPO = null, $rS = null, $kS = null, $userHomePhone = null, \ArrayType\ArrayOfImpUserAddress $userAddresses = null, $fIO = null)
    {
        $this
            ->setUserID($userID)
            ->setCreateDate($createDate)
            ->setModifyDate($modifyDate)
            ->setInternetShopID($internetShopID)
            ->setAddNewAddress($addNewAddress)
            ->setEmail($email)
            ->setUserTel($userTel)
            ->setCardNo($cardNo)
            ->setJurPerson($jurPerson)
            ->setJurAddress($jurAddress)
            ->setINN($iNN)
            ->setKPP($kPP)
            ->setOKPO($oKPO)
            ->setRS($rS)
            ->setKS($kS)
            ->setUserHomePhone($userHomePhone)
            ->setUserAddresses($userAddresses)
            ->setFIO($fIO);
    }
    /**
     * Get userID value
     * @return int
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param int $userID
     * @return \StructType\ImpUser
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
    /**
     * Get createDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\ImpUser
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get modifyDate value
     * @return string
     */
    public function getModifyDate()
    {
        return $this->modifyDate;
    }
    /**
     * Set modifyDate value
     * @param string $modifyDate
     * @return \StructType\ImpUser
     */
    public function setModifyDate($modifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifyDate) && !is_string($modifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifyDate, true), gettype($modifyDate)), __LINE__);
        }
        $this->modifyDate = $modifyDate;
        return $this;
    }
    /**
     * Get internetShopID value
     * @return int
     */
    public function getInternetShopID()
    {
        return $this->internetShopID;
    }
    /**
     * Set internetShopID value
     * @param int $internetShopID
     * @return \StructType\ImpUser
     */
    public function setInternetShopID($internetShopID = null)
    {
        // validation for constraint: int
        if (!is_null($internetShopID) && !(is_int($internetShopID) || ctype_digit($internetShopID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internetShopID, true), gettype($internetShopID)), __LINE__);
        }
        $this->internetShopID = $internetShopID;
        return $this;
    }
    /**
     * Get AddNewAddress value
     * @return bool
     */
    public function getAddNewAddress()
    {
        return $this->AddNewAddress;
    }
    /**
     * Set AddNewAddress value
     * @param bool $addNewAddress
     * @return \StructType\ImpUser
     */
    public function setAddNewAddress($addNewAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($addNewAddress) && !is_bool($addNewAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addNewAddress, true), gettype($addNewAddress)), __LINE__);
        }
        $this->AddNewAddress = $addNewAddress;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\ImpUser
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get userTel value
     * @return string|null
     */
    public function getUserTel()
    {
        return $this->userTel;
    }
    /**
     * Set userTel value
     * @param string $userTel
     * @return \StructType\ImpUser
     */
    public function setUserTel($userTel = null)
    {
        // validation for constraint: string
        if (!is_null($userTel) && !is_string($userTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userTel, true), gettype($userTel)), __LINE__);
        }
        $this->userTel = $userTel;
        return $this;
    }
    /**
     * Get cardNo value
     * @return string|null
     */
    public function getCardNo()
    {
        return $this->cardNo;
    }
    /**
     * Set cardNo value
     * @param string $cardNo
     * @return \StructType\ImpUser
     */
    public function setCardNo($cardNo = null)
    {
        // validation for constraint: string
        if (!is_null($cardNo) && !is_string($cardNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNo, true), gettype($cardNo)), __LINE__);
        }
        $this->cardNo = $cardNo;
        return $this;
    }
    /**
     * Get jurPerson value
     * @return string|null
     */
    public function getJurPerson()
    {
        return $this->jurPerson;
    }
    /**
     * Set jurPerson value
     * @param string $jurPerson
     * @return \StructType\ImpUser
     */
    public function setJurPerson($jurPerson = null)
    {
        // validation for constraint: string
        if (!is_null($jurPerson) && !is_string($jurPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jurPerson, true), gettype($jurPerson)), __LINE__);
        }
        $this->jurPerson = $jurPerson;
        return $this;
    }
    /**
     * Get jurAddress value
     * @return string|null
     */
    public function getJurAddress()
    {
        return $this->jurAddress;
    }
    /**
     * Set jurAddress value
     * @param string $jurAddress
     * @return \StructType\ImpUser
     */
    public function setJurAddress($jurAddress = null)
    {
        // validation for constraint: string
        if (!is_null($jurAddress) && !is_string($jurAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jurAddress, true), gettype($jurAddress)), __LINE__);
        }
        $this->jurAddress = $jurAddress;
        return $this;
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \StructType\ImpUser
     */
    public function setINN($iNN = null)
    {
        // validation for constraint: string
        if (!is_null($iNN) && !is_string($iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNN, true), gettype($iNN)), __LINE__);
        }
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get KPP value
     * @return string|null
     */
    public function getKPP()
    {
        return $this->KPP;
    }
    /**
     * Set KPP value
     * @param string $kPP
     * @return \StructType\ImpUser
     */
    public function setKPP($kPP = null)
    {
        // validation for constraint: string
        if (!is_null($kPP) && !is_string($kPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kPP, true), gettype($kPP)), __LINE__);
        }
        $this->KPP = $kPP;
        return $this;
    }
    /**
     * Get OKPO value
     * @return string|null
     */
    public function getOKPO()
    {
        return $this->OKPO;
    }
    /**
     * Set OKPO value
     * @param string $oKPO
     * @return \StructType\ImpUser
     */
    public function setOKPO($oKPO = null)
    {
        // validation for constraint: string
        if (!is_null($oKPO) && !is_string($oKPO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oKPO, true), gettype($oKPO)), __LINE__);
        }
        $this->OKPO = $oKPO;
        return $this;
    }
    /**
     * Get RS value
     * @return string|null
     */
    public function getRS()
    {
        return $this->RS;
    }
    /**
     * Set RS value
     * @param string $rS
     * @return \StructType\ImpUser
     */
    public function setRS($rS = null)
    {
        // validation for constraint: string
        if (!is_null($rS) && !is_string($rS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rS, true), gettype($rS)), __LINE__);
        }
        $this->RS = $rS;
        return $this;
    }
    /**
     * Get KS value
     * @return string|null
     */
    public function getKS()
    {
        return $this->KS;
    }
    /**
     * Set KS value
     * @param string $kS
     * @return \StructType\ImpUser
     */
    public function setKS($kS = null)
    {
        // validation for constraint: string
        if (!is_null($kS) && !is_string($kS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kS, true), gettype($kS)), __LINE__);
        }
        $this->KS = $kS;
        return $this;
    }
    /**
     * Get userHomePhone value
     * @return string|null
     */
    public function getUserHomePhone()
    {
        return $this->userHomePhone;
    }
    /**
     * Set userHomePhone value
     * @param string $userHomePhone
     * @return \StructType\ImpUser
     */
    public function setUserHomePhone($userHomePhone = null)
    {
        // validation for constraint: string
        if (!is_null($userHomePhone) && !is_string($userHomePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userHomePhone, true), gettype($userHomePhone)), __LINE__);
        }
        $this->userHomePhone = $userHomePhone;
        return $this;
    }
    /**
     * Get UserAddresses value
     * @return \ArrayType\ArrayOfImpUserAddress|null
     */
    public function getUserAddresses()
    {
        return $this->UserAddresses;
    }
    /**
     * Set UserAddresses value
     * @param \ArrayType\ArrayOfImpUserAddress $userAddresses
     * @return \StructType\ImpUser
     */
    public function setUserAddresses(\ArrayType\ArrayOfImpUserAddress $userAddresses = null)
    {
        $this->UserAddresses = $userAddresses;
        return $this;
    }
    /**
     * Get FIO value
     * @return string|null
     */
    public function getFIO()
    {
        return $this->FIO;
    }
    /**
     * Set FIO value
     * @param string $fIO
     * @return \StructType\ImpUser
     */
    public function setFIO($fIO = null)
    {
        // validation for constraint: string
        if (!is_null($fIO) && !is_string($fIO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fIO, true), gettype($fIO)), __LINE__);
        }
        $this->FIO = $fIO;
        return $this;
    }
}
