<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcel StructType
 * @subpackage Structs
 */
class Parcel extends AbstractStructBase
{
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $orderId;
    /**
     * The quantityPlaces
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quantityPlaces;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \ArrayType\ArrayOfPackage
     */
    public $packages;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * Constructor method for parcel
     * @uses Parcel::setOrderId()
     * @uses Parcel::setQuantityPlaces()
     * @uses Parcel::setPackages()
     * @uses Parcel::setNumber()
     * @param string $orderId
     * @param int $quantityPlaces
     * @param \ArrayType\ArrayOfPackage $packages
     * @param string $number
     */
    public function __construct($orderId = null, $quantityPlaces = null, \ArrayType\ArrayOfPackage $packages = null, $number = null)
    {
        $this
            ->setOrderId($orderId)
            ->setQuantityPlaces($quantityPlaces)
            ->setPackages($packages)
            ->setNumber($number);
    }
    /**
     * Get orderId value
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param string $orderId
     * @return \StructType\Parcel
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get quantityPlaces value
     * @return int
     */
    public function getQuantityPlaces()
    {
        return $this->quantityPlaces;
    }
    /**
     * Set quantityPlaces value
     * @param int $quantityPlaces
     * @return \StructType\Parcel
     */
    public function setQuantityPlaces($quantityPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($quantityPlaces) && !(is_int($quantityPlaces) || ctype_digit($quantityPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityPlaces, true), gettype($quantityPlaces)), __LINE__);
        }
        $this->quantityPlaces = $quantityPlaces;
        return $this;
    }
    /**
     * Get packages value
     * @return \ArrayType\ArrayOfPackage
     */
    public function getPackages()
    {
        return $this->packages;
    }
    /**
     * Set packages value
     * @param \ArrayType\ArrayOfPackage $packages
     * @return \StructType\Parcel
     */
    public function setPackages(\ArrayType\ArrayOfPackage $packages = null)
    {
        $this->packages = $packages;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\Parcel
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
}
