<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Register ServiceType
 * @subpackage Services
 */
class Register extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RegisterUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterUser $parameters
     * @return \StructType\RegisterUserResponse|bool
     */
    public function RegisterUser(\StructType\RegisterUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegisterUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegisterOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterOrder $parameters
     * @return \StructType\RegisterOrderResponse|bool
     */
    public function RegisterOrder(\StructType\RegisterOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegisterOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegisterInternetShop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterInternetShop $parameters
     * @return \StructType\RegisterInternetShopResponse|bool
     */
    public function RegisterInternetShop(\StructType\RegisterInternetShop $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegisterInternetShop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegisterChildInternetShop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterChildInternetShop $parameters
     * @return \StructType\RegisterChildInternetShopResponse|bool
     */
    public function RegisterChildInternetShop(\StructType\RegisterChildInternetShop $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegisterChildInternetShop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegisterOrderExtended
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterOrderExtended $parameters
     * @return \StructType\RegisterOrderExtendedResponse|bool
     */
    public function RegisterOrderExtended(\StructType\RegisterOrderExtended $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegisterOrderExtended($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegisterWarehouse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterWarehouse $parameters
     * @return \StructType\RegisterWarehouseResponse|bool
     */
    public function RegisterWarehouse(\StructType\RegisterWarehouse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegisterWarehouse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RegisterChildInternetShopResponse|\StructType\RegisterInternetShopResponse|\StructType\RegisterOrderExtendedResponse|\StructType\RegisterOrderResponse|\StructType\RegisterUserResponse|\StructType\RegisterWarehouseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
