<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfExpOrderItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfExpOrderItem extends AbstractStructArrayBase
{
    /**
     * The ExpOrderItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExpOrderItem[]
     */
    public $ExpOrderItem;
    /**
     * Constructor method for ArrayOfExpOrderItem
     * @uses ArrayOfExpOrderItem::setExpOrderItem()
     * @param \StructType\ExpOrderItem[] $expOrderItem
     */
    public function __construct(array $expOrderItem = array())
    {
        $this
            ->setExpOrderItem($expOrderItem);
    }
    /**
     * Get ExpOrderItem value
     * @return \StructType\ExpOrderItem[]|null
     */
    public function getExpOrderItem()
    {
        return $this->ExpOrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setExpOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpOrderItemForArrayConstraintsFromSetExpOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfExpOrderItemExpOrderItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfExpOrderItemExpOrderItemItem instanceof \StructType\ExpOrderItem) {
                $invalidValues[] = is_object($arrayOfExpOrderItemExpOrderItemItem) ? get_class($arrayOfExpOrderItemExpOrderItemItem) : sprintf('%s(%s)', gettype($arrayOfExpOrderItemExpOrderItemItem), var_export($arrayOfExpOrderItemExpOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExpOrderItem property can only contain items of type \StructType\ExpOrderItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExpOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ExpOrderItem[] $expOrderItem
     * @return \ArrayType\ArrayOfExpOrderItem
     */
    public function setExpOrderItem(array $expOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($expOrderItemArrayErrorMessage = self::validateExpOrderItemForArrayConstraintsFromSetExpOrderItem($expOrderItem))) {
            throw new \InvalidArgumentException($expOrderItemArrayErrorMessage, __LINE__);
        }
        $this->ExpOrderItem = $expOrderItem;
        return $this;
    }
    /**
     * Add item to ExpOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ExpOrderItem $item
     * @return \ArrayType\ArrayOfExpOrderItem
     */
    public function addToExpOrderItem(\StructType\ExpOrderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExpOrderItem) {
            throw new \InvalidArgumentException(sprintf('The ExpOrderItem property can only contain items of type \StructType\ExpOrderItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExpOrderItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ExpOrderItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ExpOrderItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ExpOrderItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ExpOrderItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ExpOrderItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ExpOrderItem
     */
    public function getAttributeName()
    {
        return 'ExpOrderItem';
    }
}
