<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddItemsToOrder StructType
 * @subpackage Structs
 */
class AddItemsToOrder extends AbstractStructBase
{
    /**
     * The orderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderID;
    /**
     * The orderitems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderItem
     */
    public $orderitems;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for AddItemsToOrder
     * @uses AddItemsToOrder::setOrderID()
     * @uses AddItemsToOrder::setOrderitems()
     * @uses AddItemsToOrder::setAuth()
     * @param int $orderID
     * @param \ArrayType\ArrayOfOrderItem $orderitems
     * @param \StructType\Authentication $auth
     */
    public function __construct($orderID = null, \ArrayType\ArrayOfOrderItem $orderitems = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setOrderID($orderID)
            ->setOrderitems($orderitems)
            ->setAuth($auth);
    }
    /**
     * Get orderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->orderID;
    }
    /**
     * Set orderID value
     * @param int $orderID
     * @return \StructType\AddItemsToOrder
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->orderID = $orderID;
        return $this;
    }
    /**
     * Get orderitems value
     * @return \ArrayType\ArrayOfOrderItem|null
     */
    public function getOrderitems()
    {
        return $this->orderitems;
    }
    /**
     * Set orderitems value
     * @param \ArrayType\ArrayOfOrderItem $orderitems
     * @return \StructType\AddItemsToOrder
     */
    public function setOrderitems(\ArrayType\ArrayOfOrderItem $orderitems = null)
    {
        $this->orderitems = $orderitems;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\AddItemsToOrder
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
