<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStatusChange ArrayType
 * @subpackage Arrays
 */
class ArrayOfStatusChange extends AbstractStructArrayBase
{
    /**
     * The StatusChange
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StatusChange[]
     */
    public $StatusChange;
    /**
     * Constructor method for ArrayOfStatusChange
     * @uses ArrayOfStatusChange::setStatusChange()
     * @param \StructType\StatusChange[] $statusChange
     */
    public function __construct(array $statusChange = array())
    {
        $this
            ->setStatusChange($statusChange);
    }
    /**
     * Get StatusChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StatusChange[]|null
     */
    public function getStatusChange()
    {
        return isset($this->StatusChange) ? $this->StatusChange : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStatusChange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatusChange method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusChangeForArrayConstraintsFromSetStatusChange(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStatusChangeStatusChangeItem) {
            // validation for constraint: itemType
            if (!$arrayOfStatusChangeStatusChangeItem instanceof \StructType\StatusChange) {
                $invalidValues[] = is_object($arrayOfStatusChangeStatusChangeItem) ? get_class($arrayOfStatusChangeStatusChangeItem) : sprintf('%s(%s)', gettype($arrayOfStatusChangeStatusChangeItem), var_export($arrayOfStatusChangeStatusChangeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StatusChange property can only contain items of type \StructType\StatusChange, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatusChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StatusChange[] $statusChange
     * @return \ArrayType\ArrayOfStatusChange
     */
    public function setStatusChange(array $statusChange = array())
    {
        // validation for constraint: array
        if ('' !== ($statusChangeArrayErrorMessage = self::validateStatusChangeForArrayConstraintsFromSetStatusChange($statusChange))) {
            throw new \InvalidArgumentException($statusChangeArrayErrorMessage, __LINE__);
        }
        if (is_null($statusChange) || (is_array($statusChange) && empty($statusChange))) {
            unset($this->StatusChange);
        } else {
            $this->StatusChange = $statusChange;
        }
        return $this;
    }
    /**
     * Add item to StatusChange value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusChange $item
     * @return \ArrayType\ArrayOfStatusChange
     */
    public function addToStatusChange(\StructType\StatusChange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StatusChange) {
            throw new \InvalidArgumentException(sprintf('The StatusChange property can only contain items of type \StructType\StatusChange, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StatusChange[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\StatusChange|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\StatusChange|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\StatusChange|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\StatusChange|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\StatusChange|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StatusChange
     */
    public function getAttributeName()
    {
        return 'StatusChange';
    }
}
