<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetOrderParams StructType
 * @subpackage Structs
 */
class SetOrderParams extends AbstractStructBase
{
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderId;
    /**
     * The PiecesOfFreight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PiecesOfFreight;
    /**
     * The orderWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderWeight;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for SetOrderParams
     * @uses SetOrderParams::setOrderId()
     * @uses SetOrderParams::setPiecesOfFreight()
     * @uses SetOrderParams::setOrderWeight()
     * @uses SetOrderParams::setAuth()
     * @param int $orderId
     * @param int $piecesOfFreight
     * @param string $orderWeight
     * @param \StructType\Authentication $auth
     */
    public function __construct($orderId = null, $piecesOfFreight = null, $orderWeight = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setOrderId($orderId)
            ->setPiecesOfFreight($piecesOfFreight)
            ->setOrderWeight($orderWeight)
            ->setAuth($auth);
    }
    /**
     * Get orderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \StructType\SetOrderParams
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get PiecesOfFreight value
     * @return int
     */
    public function getPiecesOfFreight()
    {
        return $this->PiecesOfFreight;
    }
    /**
     * Set PiecesOfFreight value
     * @param int $piecesOfFreight
     * @return \StructType\SetOrderParams
     */
    public function setPiecesOfFreight($piecesOfFreight = null)
    {
        // validation for constraint: int
        if (!is_null($piecesOfFreight) && !(is_int($piecesOfFreight) || ctype_digit($piecesOfFreight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($piecesOfFreight, true), gettype($piecesOfFreight)), __LINE__);
        }
        $this->PiecesOfFreight = $piecesOfFreight;
        return $this;
    }
    /**
     * Get orderWeight value
     * @return string|null
     */
    public function getOrderWeight()
    {
        return $this->orderWeight;
    }
    /**
     * Set orderWeight value
     * @param string $orderWeight
     * @return \StructType\SetOrderParams
     */
    public function setOrderWeight($orderWeight = null)
    {
        // validation for constraint: string
        if (!is_null($orderWeight) && !is_string($orderWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderWeight, true), gettype($orderWeight)), __LINE__);
        }
        $this->orderWeight = $orderWeight;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\SetOrderParams
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
