<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetOrderBarcodes StructType
 * @subpackage Structs
 */
class SetOrderBarcodes extends AbstractStructBase
{
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderId;
    /**
     * The barcodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPieceBarcode
     */
    public $barcodes;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for SetOrderBarcodes
     * @uses SetOrderBarcodes::setOrderId()
     * @uses SetOrderBarcodes::setBarcodes()
     * @uses SetOrderBarcodes::setAuth()
     * @param int $orderId
     * @param \ArrayType\ArrayOfPieceBarcode $barcodes
     * @param \StructType\Authentication $auth
     */
    public function __construct($orderId = null, \ArrayType\ArrayOfPieceBarcode $barcodes = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setOrderId($orderId)
            ->setBarcodes($barcodes)
            ->setAuth($auth);
    }
    /**
     * Get orderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \StructType\SetOrderBarcodes
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get barcodes value
     * @return \ArrayType\ArrayOfPieceBarcode|null
     */
    public function getBarcodes()
    {
        return $this->barcodes;
    }
    /**
     * Set barcodes value
     * @param \ArrayType\ArrayOfPieceBarcode $barcodes
     * @return \StructType\SetOrderBarcodes
     */
    public function setBarcodes(\ArrayType\ArrayOfPieceBarcode $barcodes = null)
    {
        $this->barcodes = $barcodes;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\SetOrderBarcodes
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
