<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterOrder StructType
 * @subpackage Structs
 */
class RegisterOrder extends AbstractStructBase
{
    /**
     * The order
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ImpOrder
     */
    public $order;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for RegisterOrder
     * @uses RegisterOrder::setOrder()
     * @uses RegisterOrder::setAuth()
     * @param \StructType\ImpOrder $order
     * @param \StructType\Authentication $auth
     */
    public function __construct(\StructType\ImpOrder $order = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setOrder($order)
            ->setAuth($auth);
    }
    /**
     * Get order value
     * @return \StructType\ImpOrder|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param \StructType\ImpOrder $order
     * @return \StructType\RegisterOrder
     */
    public function setOrder(\StructType\ImpOrder $order = null)
    {
        $this->order = $order;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\RegisterOrder
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
