<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSdOrderID StructType
 * @subpackage Structs
 */
class GetSdOrderID extends AbstractStructBase
{
    /**
     * The shopID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $shopID;
    /**
     * The orderImportID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderImportID;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for GetSdOrderID
     * @uses GetSdOrderID::setShopID()
     * @uses GetSdOrderID::setOrderImportID()
     * @uses GetSdOrderID::setAuth()
     * @param int $shopID
     * @param string $orderImportID
     * @param \StructType\Authentication $auth
     */
    public function __construct($shopID = null, $orderImportID = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setShopID($shopID)
            ->setOrderImportID($orderImportID)
            ->setAuth($auth);
    }
    /**
     * Get shopID value
     * @return int
     */
    public function getShopID()
    {
        return $this->shopID;
    }
    /**
     * Set shopID value
     * @param int $shopID
     * @return \StructType\GetSdOrderID
     */
    public function setShopID($shopID = null)
    {
        // validation for constraint: int
        if (!is_null($shopID) && !(is_int($shopID) || ctype_digit($shopID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shopID, true), gettype($shopID)), __LINE__);
        }
        $this->shopID = $shopID;
        return $this;
    }
    /**
     * Get orderImportID value
     * @return string|null
     */
    public function getOrderImportID()
    {
        return $this->orderImportID;
    }
    /**
     * Set orderImportID value
     * @param string $orderImportID
     * @return \StructType\GetSdOrderID
     */
    public function setOrderImportID($orderImportID = null)
    {
        // validation for constraint: string
        if (!is_null($orderImportID) && !is_string($orderImportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderImportID, true), gettype($orderImportID)), __LINE__);
        }
        $this->orderImportID = $orderImportID;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetSdOrderID
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
