<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetOrderIDAdditional StructType
 * @subpackage Structs
 */
class SetOrderIDAdditional extends AbstractStructBase
{
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderId;
    /**
     * The orderIDAdditional
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderIDAdditional;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for SetOrderIDAdditional
     * @uses SetOrderIDAdditional::setOrderId()
     * @uses SetOrderIDAdditional::setOrderIDAdditional()
     * @uses SetOrderIDAdditional::setAuth()
     * @param int $orderId
     * @param string $orderIDAdditional
     * @param \StructType\Authentication $auth
     */
    public function __construct($orderId = null, $orderIDAdditional = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setOrderId($orderId)
            ->setOrderIDAdditional($orderIDAdditional)
            ->setAuth($auth);
    }
    /**
     * Get orderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \StructType\SetOrderIDAdditional
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get orderIDAdditional value
     * @return string|null
     */
    public function getOrderIDAdditional()
    {
        return $this->orderIDAdditional;
    }
    /**
     * Set orderIDAdditional value
     * @param string $orderIDAdditional
     * @return \StructType\SetOrderIDAdditional
     */
    public function setOrderIDAdditional($orderIDAdditional = null)
    {
        // validation for constraint: string
        if (!is_null($orderIDAdditional) && !is_string($orderIDAdditional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderIDAdditional, true), gettype($orderIDAdditional)), __LINE__);
        }
        $this->orderIDAdditional = $orderIDAdditional;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\SetOrderIDAdditional
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
