<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Status StructType
 * @subpackage Structs
 */
class Status extends AbstractStructBase
{
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderId;
    /**
     * The statusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $statusId;
    /**
     * The statusName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $statusName;
    /**
     * The carNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $carNumber;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * Constructor method for Status
     * @uses Status::setOrderId()
     * @uses Status::setStatusId()
     * @uses Status::setStatusName()
     * @uses Status::setCarNumber()
     * @uses Status::setPhone()
     * @param int $orderId
     * @param int $statusId
     * @param string $statusName
     * @param string $carNumber
     * @param string $phone
     */
    public function __construct($orderId = null, $statusId = null, $statusName = null, $carNumber = null, $phone = null)
    {
        $this
            ->setOrderId($orderId)
            ->setStatusId($statusId)
            ->setStatusName($statusName)
            ->setCarNumber($carNumber)
            ->setPhone($phone);
    }
    /**
     * Get orderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \StructType\Status
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get statusId value
     * @return int
     */
    public function getStatusId()
    {
        return $this->statusId;
    }
    /**
     * Set statusId value
     * @param int $statusId
     * @return \StructType\Status
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: int
        if (!is_null($statusId) && !(is_int($statusId) || ctype_digit($statusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusId, true), gettype($statusId)), __LINE__);
        }
        $this->statusId = $statusId;
        return $this;
    }
    /**
     * Get statusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->statusName;
    }
    /**
     * Set statusName value
     * @param string $statusName
     * @return \StructType\Status
     */
    public function setStatusName($statusName = null)
    {
        // validation for constraint: string
        if (!is_null($statusName) && !is_string($statusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusName, true), gettype($statusName)), __LINE__);
        }
        $this->statusName = $statusName;
        return $this;
    }
    /**
     * Get carNumber value
     * @return string|null
     */
    public function getCarNumber()
    {
        return $this->carNumber;
    }
    /**
     * Set carNumber value
     * @param string $carNumber
     * @return \StructType\Status
     */
    public function setCarNumber($carNumber = null)
    {
        // validation for constraint: string
        if (!is_null($carNumber) && !is_string($carNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carNumber, true), gettype($carNumber)), __LINE__);
        }
        $this->carNumber = $carNumber;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\Status
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Status
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
