<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Warehouse StructType
 * @subpackage Structs
 */
class Warehouse extends AbstractStructBase
{
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The StockIdImport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StockIdImport;
    /**
     * The StockName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StockName;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The OrganizationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrganizationName;
    /**
     * The OrganizationINN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrganizationINN;
    /**
     * The TimeIntervalReceiptFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeIntervalReceiptFrom;
    /**
     * The TimeIntervalReceiptTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeIntervalReceiptTo;
    /**
     * The ContactPersonName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactPersonName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Warehouse
     * @uses Warehouse::setLatitude()
     * @uses Warehouse::setLongitude()
     * @uses Warehouse::setStockIdImport()
     * @uses Warehouse::setStockName()
     * @uses Warehouse::setPhoneNumber()
     * @uses Warehouse::setAddress()
     * @uses Warehouse::setOrganizationName()
     * @uses Warehouse::setOrganizationINN()
     * @uses Warehouse::setTimeIntervalReceiptFrom()
     * @uses Warehouse::setTimeIntervalReceiptTo()
     * @uses Warehouse::setContactPersonName()
     * @uses Warehouse::setEmail()
     * @uses Warehouse::setComment()
     * @param float $latitude
     * @param float $longitude
     * @param string $stockIdImport
     * @param string $stockName
     * @param string $phoneNumber
     * @param string $address
     * @param string $organizationName
     * @param string $organizationINN
     * @param string $timeIntervalReceiptFrom
     * @param string $timeIntervalReceiptTo
     * @param string $contactPersonName
     * @param string $email
     * @param string $comment
     */
    public function __construct($latitude = null, $longitude = null, $stockIdImport = null, $stockName = null, $phoneNumber = null, $address = null, $organizationName = null, $organizationINN = null, $timeIntervalReceiptFrom = null, $timeIntervalReceiptTo = null, $contactPersonName = null, $email = null, $comment = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setStockIdImport($stockIdImport)
            ->setStockName($stockName)
            ->setPhoneNumber($phoneNumber)
            ->setAddress($address)
            ->setOrganizationName($organizationName)
            ->setOrganizationINN($organizationINN)
            ->setTimeIntervalReceiptFrom($timeIntervalReceiptFrom)
            ->setTimeIntervalReceiptTo($timeIntervalReceiptTo)
            ->setContactPersonName($contactPersonName)
            ->setEmail($email)
            ->setComment($comment);
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\Warehouse
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\Warehouse
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get StockIdImport value
     * @return string|null
     */
    public function getStockIdImport()
    {
        return $this->StockIdImport;
    }
    /**
     * Set StockIdImport value
     * @param string $stockIdImport
     * @return \StructType\Warehouse
     */
    public function setStockIdImport($stockIdImport = null)
    {
        // validation for constraint: string
        if (!is_null($stockIdImport) && !is_string($stockIdImport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockIdImport, true), gettype($stockIdImport)), __LINE__);
        }
        $this->StockIdImport = $stockIdImport;
        return $this;
    }
    /**
     * Get StockName value
     * @return string|null
     */
    public function getStockName()
    {
        return $this->StockName;
    }
    /**
     * Set StockName value
     * @param string $stockName
     * @return \StructType\Warehouse
     */
    public function setStockName($stockName = null)
    {
        // validation for constraint: string
        if (!is_null($stockName) && !is_string($stockName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockName, true), gettype($stockName)), __LINE__);
        }
        $this->StockName = $stockName;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\Warehouse
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\Warehouse
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get OrganizationName value
     * @return string|null
     */
    public function getOrganizationName()
    {
        return $this->OrganizationName;
    }
    /**
     * Set OrganizationName value
     * @param string $organizationName
     * @return \StructType\Warehouse
     */
    public function setOrganizationName($organizationName = null)
    {
        // validation for constraint: string
        if (!is_null($organizationName) && !is_string($organizationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationName, true), gettype($organizationName)), __LINE__);
        }
        $this->OrganizationName = $organizationName;
        return $this;
    }
    /**
     * Get OrganizationINN value
     * @return string|null
     */
    public function getOrganizationINN()
    {
        return $this->OrganizationINN;
    }
    /**
     * Set OrganizationINN value
     * @param string $organizationINN
     * @return \StructType\Warehouse
     */
    public function setOrganizationINN($organizationINN = null)
    {
        // validation for constraint: string
        if (!is_null($organizationINN) && !is_string($organizationINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationINN, true), gettype($organizationINN)), __LINE__);
        }
        $this->OrganizationINN = $organizationINN;
        return $this;
    }
    /**
     * Get TimeIntervalReceiptFrom value
     * @return string|null
     */
    public function getTimeIntervalReceiptFrom()
    {
        return $this->TimeIntervalReceiptFrom;
    }
    /**
     * Set TimeIntervalReceiptFrom value
     * @param string $timeIntervalReceiptFrom
     * @return \StructType\Warehouse
     */
    public function setTimeIntervalReceiptFrom($timeIntervalReceiptFrom = null)
    {
        // validation for constraint: string
        if (!is_null($timeIntervalReceiptFrom) && !is_string($timeIntervalReceiptFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeIntervalReceiptFrom, true), gettype($timeIntervalReceiptFrom)), __LINE__);
        }
        $this->TimeIntervalReceiptFrom = $timeIntervalReceiptFrom;
        return $this;
    }
    /**
     * Get TimeIntervalReceiptTo value
     * @return string|null
     */
    public function getTimeIntervalReceiptTo()
    {
        return $this->TimeIntervalReceiptTo;
    }
    /**
     * Set TimeIntervalReceiptTo value
     * @param string $timeIntervalReceiptTo
     * @return \StructType\Warehouse
     */
    public function setTimeIntervalReceiptTo($timeIntervalReceiptTo = null)
    {
        // validation for constraint: string
        if (!is_null($timeIntervalReceiptTo) && !is_string($timeIntervalReceiptTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeIntervalReceiptTo, true), gettype($timeIntervalReceiptTo)), __LINE__);
        }
        $this->TimeIntervalReceiptTo = $timeIntervalReceiptTo;
        return $this;
    }
    /**
     * Get ContactPersonName value
     * @return string|null
     */
    public function getContactPersonName()
    {
        return $this->ContactPersonName;
    }
    /**
     * Set ContactPersonName value
     * @param string $contactPersonName
     * @return \StructType\Warehouse
     */
    public function setContactPersonName($contactPersonName = null)
    {
        // validation for constraint: string
        if (!is_null($contactPersonName) && !is_string($contactPersonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPersonName, true), gettype($contactPersonName)), __LINE__);
        }
        $this->ContactPersonName = $contactPersonName;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Warehouse
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Warehouse
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Warehouse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
