<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterOrderExtended StructType
 * @subpackage Structs
 */
class RegisterOrderExtended extends AbstractStructBase
{
    /**
     * The order
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: s1:order
     * @var \StructType\Order
     */
    public $order;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for RegisterOrderExtended
     * @uses RegisterOrderExtended::setOrder()
     * @uses RegisterOrderExtended::setAuth()
     * @param \StructType\Order $order
     * @param \StructType\Authentication $auth
     */
    public function __construct(\StructType\Order $order = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setOrder($order)
            ->setAuth($auth);
    }
    /**
     * Get order value
     * @return \StructType\Order
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param \StructType\Order $order
     * @return \StructType\RegisterOrderExtended
     */
    public function setOrder(\StructType\Order $order = null)
    {
        $this->order = $order;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\RegisterOrderExtended
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegisterOrderExtended
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
