<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderPlace ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderPlace extends AbstractStructArrayBase
{
    /**
     * The OrderPlace
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderPlace[]
     */
    public $OrderPlace;
    /**
     * Constructor method for ArrayOfOrderPlace
     * @uses ArrayOfOrderPlace::setOrderPlace()
     * @param \StructType\OrderPlace[] $orderPlace
     */
    public function __construct(array $orderPlace = array())
    {
        $this
            ->setOrderPlace($orderPlace);
    }
    /**
     * Get OrderPlace value
     * @return \StructType\OrderPlace[]|null
     */
    public function getOrderPlace()
    {
        return $this->OrderPlace;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderPlace method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderPlace method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderPlaceForArrayConstraintsFromSetOrderPlace(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderPlaceOrderPlaceItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderPlaceOrderPlaceItem instanceof \StructType\OrderPlace) {
                $invalidValues[] = is_object($arrayOfOrderPlaceOrderPlaceItem) ? get_class($arrayOfOrderPlaceOrderPlaceItem) : sprintf('%s(%s)', gettype($arrayOfOrderPlaceOrderPlaceItem), var_export($arrayOfOrderPlaceOrderPlaceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderPlace property can only contain items of type \StructType\OrderPlace, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderPlace value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderPlace[] $orderPlace
     * @return \ArrayType\ArrayOfOrderPlace
     */
    public function setOrderPlace(array $orderPlace = array())
    {
        // validation for constraint: array
        if ('' !== ($orderPlaceArrayErrorMessage = self::validateOrderPlaceForArrayConstraintsFromSetOrderPlace($orderPlace))) {
            throw new \InvalidArgumentException($orderPlaceArrayErrorMessage, __LINE__);
        }
        $this->OrderPlace = $orderPlace;
        return $this;
    }
    /**
     * Add item to OrderPlace value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderPlace $item
     * @return \ArrayType\ArrayOfOrderPlace
     */
    public function addToOrderPlace(\StructType\OrderPlace $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderPlace) {
            throw new \InvalidArgumentException(sprintf('The OrderPlace property can only contain items of type \StructType\OrderPlace, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderPlace[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderPlace|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderPlace|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderPlace|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderPlace|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderPlace|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderPlace
     */
    public function getAttributeName()
    {
        return 'OrderPlace';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOrderPlace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
