<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpOrder StructType
 * @subpackage Structs
 */
class ExpOrder extends AbstractStructBase
{
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The OrderStatusID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderStatusID;
    /**
     * The PayTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayTypeID;
    /**
     * The ShopUrNameID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ShopUrNameID;
    /**
     * The IsRefusalWithDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRefusalWithDelivery;
    /**
     * The DateDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateDelivery;
    /**
     * The CompleteDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CompleteDate;
    /**
     * The SelfDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SelfDelivery;
    /**
     * The TypeDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TypeDelivery;
    /**
     * The IsPayed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsPayed;
    /**
     * The FIO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FIO;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryAddress;
    /**
     * The OrderStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderStatus;
    /**
     * The ReasonRrefusal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonRrefusal;
    /**
     * The PayType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayType;
    /**
     * The ShopUrName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopUrName;
    /**
     * The ServiceDC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Money
     */
    public $ServiceDC;
    /**
     * The CashService
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Money
     */
    public $CashService;
    /**
     * The TimeDeliveryFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeDeliveryFrom;
    /**
     * The TimeDeliveryTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeDeliveryTo;
    /**
     * The DeliveryRur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Money
     */
    public $DeliveryRur;
    /**
     * The DeliveryMKAD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Money
     */
    public $DeliveryMKAD;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExpOrderItem
     */
    public $Items;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Error;
    /**
     * Constructor method for ExpOrder
     * @uses ExpOrder::setOrderID()
     * @uses ExpOrder::setUserID()
     * @uses ExpOrder::setOrderStatusID()
     * @uses ExpOrder::setPayTypeID()
     * @uses ExpOrder::setShopUrNameID()
     * @uses ExpOrder::setIsRefusalWithDelivery()
     * @uses ExpOrder::setDateDelivery()
     * @uses ExpOrder::setCompleteDate()
     * @uses ExpOrder::setSelfDelivery()
     * @uses ExpOrder::setTypeDelivery()
     * @uses ExpOrder::setIsPayed()
     * @uses ExpOrder::setFIO()
     * @uses ExpOrder::setPhone()
     * @uses ExpOrder::setDeliveryAddress()
     * @uses ExpOrder::setOrderStatus()
     * @uses ExpOrder::setReasonRrefusal()
     * @uses ExpOrder::setPayType()
     * @uses ExpOrder::setShopUrName()
     * @uses ExpOrder::setServiceDC()
     * @uses ExpOrder::setCashService()
     * @uses ExpOrder::setTimeDeliveryFrom()
     * @uses ExpOrder::setTimeDeliveryTo()
     * @uses ExpOrder::setDeliveryRur()
     * @uses ExpOrder::setDeliveryMKAD()
     * @uses ExpOrder::setComment()
     * @uses ExpOrder::setItems()
     * @uses ExpOrder::setError()
     * @param int $orderID
     * @param int $userID
     * @param int $orderStatusID
     * @param int $payTypeID
     * @param int $shopUrNameID
     * @param bool $isRefusalWithDelivery
     * @param string $dateDelivery
     * @param string $completeDate
     * @param int $selfDelivery
     * @param int $typeDelivery
     * @param int $isPayed
     * @param string $fIO
     * @param string $phone
     * @param string $deliveryAddress
     * @param string $orderStatus
     * @param string $reasonRrefusal
     * @param string $payType
     * @param string $shopUrName
     * @param \StructType\Money $serviceDC
     * @param \StructType\Money $cashService
     * @param string $timeDeliveryFrom
     * @param string $timeDeliveryTo
     * @param \StructType\Money $deliveryRur
     * @param \StructType\Money $deliveryMKAD
     * @param string $comment
     * @param \ArrayType\ArrayOfExpOrderItem $items
     * @param string $error
     */
    public function __construct($orderID = null, $userID = null, $orderStatusID = null, $payTypeID = null, $shopUrNameID = null, $isRefusalWithDelivery = null, $dateDelivery = null, $completeDate = null, $selfDelivery = null, $typeDelivery = null, $isPayed = null, $fIO = null, $phone = null, $deliveryAddress = null, $orderStatus = null, $reasonRrefusal = null, $payType = null, $shopUrName = null, \StructType\Money $serviceDC = null, \StructType\Money $cashService = null, $timeDeliveryFrom = null, $timeDeliveryTo = null, \StructType\Money $deliveryRur = null, \StructType\Money $deliveryMKAD = null, $comment = null, \ArrayType\ArrayOfExpOrderItem $items = null, $error = null)
    {
        $this
            ->setOrderID($orderID)
            ->setUserID($userID)
            ->setOrderStatusID($orderStatusID)
            ->setPayTypeID($payTypeID)
            ->setShopUrNameID($shopUrNameID)
            ->setIsRefusalWithDelivery($isRefusalWithDelivery)
            ->setDateDelivery($dateDelivery)
            ->setCompleteDate($completeDate)
            ->setSelfDelivery($selfDelivery)
            ->setTypeDelivery($typeDelivery)
            ->setIsPayed($isPayed)
            ->setFIO($fIO)
            ->setPhone($phone)
            ->setDeliveryAddress($deliveryAddress)
            ->setOrderStatus($orderStatus)
            ->setReasonRrefusal($reasonRrefusal)
            ->setPayType($payType)
            ->setShopUrName($shopUrName)
            ->setServiceDC($serviceDC)
            ->setCashService($cashService)
            ->setTimeDeliveryFrom($timeDeliveryFrom)
            ->setTimeDeliveryTo($timeDeliveryTo)
            ->setDeliveryRur($deliveryRur)
            ->setDeliveryMKAD($deliveryMKAD)
            ->setComment($comment)
            ->setItems($items)
            ->setError($error);
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\ExpOrder
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \StructType\ExpOrder
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get OrderStatusID value
     * @return int
     */
    public function getOrderStatusID()
    {
        return $this->OrderStatusID;
    }
    /**
     * Set OrderStatusID value
     * @param int $orderStatusID
     * @return \StructType\ExpOrder
     */
    public function setOrderStatusID($orderStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($orderStatusID) && !(is_int($orderStatusID) || ctype_digit($orderStatusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderStatusID, true), gettype($orderStatusID)), __LINE__);
        }
        $this->OrderStatusID = $orderStatusID;
        return $this;
    }
    /**
     * Get PayTypeID value
     * @return int
     */
    public function getPayTypeID()
    {
        return $this->PayTypeID;
    }
    /**
     * Set PayTypeID value
     * @param int $payTypeID
     * @return \StructType\ExpOrder
     */
    public function setPayTypeID($payTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($payTypeID) && !(is_int($payTypeID) || ctype_digit($payTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payTypeID, true), gettype($payTypeID)), __LINE__);
        }
        $this->PayTypeID = $payTypeID;
        return $this;
    }
    /**
     * Get ShopUrNameID value
     * @return int
     */
    public function getShopUrNameID()
    {
        return $this->ShopUrNameID;
    }
    /**
     * Set ShopUrNameID value
     * @param int $shopUrNameID
     * @return \StructType\ExpOrder
     */
    public function setShopUrNameID($shopUrNameID = null)
    {
        // validation for constraint: int
        if (!is_null($shopUrNameID) && !(is_int($shopUrNameID) || ctype_digit($shopUrNameID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shopUrNameID, true), gettype($shopUrNameID)), __LINE__);
        }
        $this->ShopUrNameID = $shopUrNameID;
        return $this;
    }
    /**
     * Get IsRefusalWithDelivery value
     * @return bool
     */
    public function getIsRefusalWithDelivery()
    {
        return $this->IsRefusalWithDelivery;
    }
    /**
     * Set IsRefusalWithDelivery value
     * @param bool $isRefusalWithDelivery
     * @return \StructType\ExpOrder
     */
    public function setIsRefusalWithDelivery($isRefusalWithDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRefusalWithDelivery) && !is_bool($isRefusalWithDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRefusalWithDelivery, true), gettype($isRefusalWithDelivery)), __LINE__);
        }
        $this->IsRefusalWithDelivery = $isRefusalWithDelivery;
        return $this;
    }
    /**
     * Get DateDelivery value
     * @return string
     */
    public function getDateDelivery()
    {
        return $this->DateDelivery;
    }
    /**
     * Set DateDelivery value
     * @param string $dateDelivery
     * @return \StructType\ExpOrder
     */
    public function setDateDelivery($dateDelivery = null)
    {
        // validation for constraint: string
        if (!is_null($dateDelivery) && !is_string($dateDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDelivery, true), gettype($dateDelivery)), __LINE__);
        }
        $this->DateDelivery = $dateDelivery;
        return $this;
    }
    /**
     * Get CompleteDate value
     * @return string
     */
    public function getCompleteDate()
    {
        return $this->CompleteDate;
    }
    /**
     * Set CompleteDate value
     * @param string $completeDate
     * @return \StructType\ExpOrder
     */
    public function setCompleteDate($completeDate = null)
    {
        // validation for constraint: string
        if (!is_null($completeDate) && !is_string($completeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completeDate, true), gettype($completeDate)), __LINE__);
        }
        $this->CompleteDate = $completeDate;
        return $this;
    }
    /**
     * Get SelfDelivery value
     * @return int
     */
    public function getSelfDelivery()
    {
        return $this->SelfDelivery;
    }
    /**
     * Set SelfDelivery value
     * @param int $selfDelivery
     * @return \StructType\ExpOrder
     */
    public function setSelfDelivery($selfDelivery = null)
    {
        // validation for constraint: int
        if (!is_null($selfDelivery) && !(is_int($selfDelivery) || ctype_digit($selfDelivery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selfDelivery, true), gettype($selfDelivery)), __LINE__);
        }
        $this->SelfDelivery = $selfDelivery;
        return $this;
    }
    /**
     * Get TypeDelivery value
     * @return int
     */
    public function getTypeDelivery()
    {
        return $this->TypeDelivery;
    }
    /**
     * Set TypeDelivery value
     * @param int $typeDelivery
     * @return \StructType\ExpOrder
     */
    public function setTypeDelivery($typeDelivery = null)
    {
        // validation for constraint: int
        if (!is_null($typeDelivery) && !(is_int($typeDelivery) || ctype_digit($typeDelivery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeDelivery, true), gettype($typeDelivery)), __LINE__);
        }
        $this->TypeDelivery = $typeDelivery;
        return $this;
    }
    /**
     * Get IsPayed value
     * @return int
     */
    public function getIsPayed()
    {
        return $this->IsPayed;
    }
    /**
     * Set IsPayed value
     * @param int $isPayed
     * @return \StructType\ExpOrder
     */
    public function setIsPayed($isPayed = null)
    {
        // validation for constraint: int
        if (!is_null($isPayed) && !(is_int($isPayed) || ctype_digit($isPayed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isPayed, true), gettype($isPayed)), __LINE__);
        }
        $this->IsPayed = $isPayed;
        return $this;
    }
    /**
     * Get FIO value
     * @return string|null
     */
    public function getFIO()
    {
        return $this->FIO;
    }
    /**
     * Set FIO value
     * @param string $fIO
     * @return \StructType\ExpOrder
     */
    public function setFIO($fIO = null)
    {
        // validation for constraint: string
        if (!is_null($fIO) && !is_string($fIO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fIO, true), gettype($fIO)), __LINE__);
        }
        $this->FIO = $fIO;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\ExpOrder
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return string|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param string $deliveryAddress
     * @return \StructType\ExpOrder
     */
    public function setDeliveryAddress($deliveryAddress = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddress) && !is_string($deliveryAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddress, true), gettype($deliveryAddress)), __LINE__);
        }
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get OrderStatus value
     * @return string|null
     */
    public function getOrderStatus()
    {
        return $this->OrderStatus;
    }
    /**
     * Set OrderStatus value
     * @param string $orderStatus
     * @return \StructType\ExpOrder
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: string
        if (!is_null($orderStatus) && !is_string($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderStatus, true), gettype($orderStatus)), __LINE__);
        }
        $this->OrderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get ReasonRrefusal value
     * @return string|null
     */
    public function getReasonRrefusal()
    {
        return $this->ReasonRrefusal;
    }
    /**
     * Set ReasonRrefusal value
     * @param string $reasonRrefusal
     * @return \StructType\ExpOrder
     */
    public function setReasonRrefusal($reasonRrefusal = null)
    {
        // validation for constraint: string
        if (!is_null($reasonRrefusal) && !is_string($reasonRrefusal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonRrefusal, true), gettype($reasonRrefusal)), __LINE__);
        }
        $this->ReasonRrefusal = $reasonRrefusal;
        return $this;
    }
    /**
     * Get PayType value
     * @return string|null
     */
    public function getPayType()
    {
        return $this->PayType;
    }
    /**
     * Set PayType value
     * @param string $payType
     * @return \StructType\ExpOrder
     */
    public function setPayType($payType = null)
    {
        // validation for constraint: string
        if (!is_null($payType) && !is_string($payType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payType, true), gettype($payType)), __LINE__);
        }
        $this->PayType = $payType;
        return $this;
    }
    /**
     * Get ShopUrName value
     * @return string|null
     */
    public function getShopUrName()
    {
        return $this->ShopUrName;
    }
    /**
     * Set ShopUrName value
     * @param string $shopUrName
     * @return \StructType\ExpOrder
     */
    public function setShopUrName($shopUrName = null)
    {
        // validation for constraint: string
        if (!is_null($shopUrName) && !is_string($shopUrName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopUrName, true), gettype($shopUrName)), __LINE__);
        }
        $this->ShopUrName = $shopUrName;
        return $this;
    }
    /**
     * Get ServiceDC value
     * @return \StructType\Money|null
     */
    public function getServiceDC()
    {
        return $this->ServiceDC;
    }
    /**
     * Set ServiceDC value
     * @param \StructType\Money $serviceDC
     * @return \StructType\ExpOrder
     */
    public function setServiceDC(\StructType\Money $serviceDC = null)
    {
        $this->ServiceDC = $serviceDC;
        return $this;
    }
    /**
     * Get CashService value
     * @return \StructType\Money|null
     */
    public function getCashService()
    {
        return $this->CashService;
    }
    /**
     * Set CashService value
     * @param \StructType\Money $cashService
     * @return \StructType\ExpOrder
     */
    public function setCashService(\StructType\Money $cashService = null)
    {
        $this->CashService = $cashService;
        return $this;
    }
    /**
     * Get TimeDeliveryFrom value
     * @return string|null
     */
    public function getTimeDeliveryFrom()
    {
        return $this->TimeDeliveryFrom;
    }
    /**
     * Set TimeDeliveryFrom value
     * @param string $timeDeliveryFrom
     * @return \StructType\ExpOrder
     */
    public function setTimeDeliveryFrom($timeDeliveryFrom = null)
    {
        // validation for constraint: string
        if (!is_null($timeDeliveryFrom) && !is_string($timeDeliveryFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDeliveryFrom, true), gettype($timeDeliveryFrom)), __LINE__);
        }
        $this->TimeDeliveryFrom = $timeDeliveryFrom;
        return $this;
    }
    /**
     * Get TimeDeliveryTo value
     * @return string|null
     */
    public function getTimeDeliveryTo()
    {
        return $this->TimeDeliveryTo;
    }
    /**
     * Set TimeDeliveryTo value
     * @param string $timeDeliveryTo
     * @return \StructType\ExpOrder
     */
    public function setTimeDeliveryTo($timeDeliveryTo = null)
    {
        // validation for constraint: string
        if (!is_null($timeDeliveryTo) && !is_string($timeDeliveryTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDeliveryTo, true), gettype($timeDeliveryTo)), __LINE__);
        }
        $this->TimeDeliveryTo = $timeDeliveryTo;
        return $this;
    }
    /**
     * Get DeliveryRur value
     * @return \StructType\Money|null
     */
    public function getDeliveryRur()
    {
        return $this->DeliveryRur;
    }
    /**
     * Set DeliveryRur value
     * @param \StructType\Money $deliveryRur
     * @return \StructType\ExpOrder
     */
    public function setDeliveryRur(\StructType\Money $deliveryRur = null)
    {
        $this->DeliveryRur = $deliveryRur;
        return $this;
    }
    /**
     * Get DeliveryMKAD value
     * @return \StructType\Money|null
     */
    public function getDeliveryMKAD()
    {
        return $this->DeliveryMKAD;
    }
    /**
     * Set DeliveryMKAD value
     * @param \StructType\Money $deliveryMKAD
     * @return \StructType\ExpOrder
     */
    public function setDeliveryMKAD(\StructType\Money $deliveryMKAD = null)
    {
        $this->DeliveryMKAD = $deliveryMKAD;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\ExpOrder
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Items value
     * @return \ArrayType\ArrayOfExpOrderItem|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \ArrayType\ArrayOfExpOrderItem $items
     * @return \StructType\ExpOrder
     */
    public function setItems(\ArrayType\ArrayOfExpOrderItem $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \StructType\ExpOrder
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExpOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
