<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeOrderStatus StructType
 * @subpackage Structs
 */
class ChangeOrderStatus extends AbstractStructBase
{
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderId;
    /**
     * The statusWay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $statusWay;
    /**
     * The statuses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfStatusChange
     */
    public $statuses;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for ChangeOrderStatus
     * @uses ChangeOrderStatus::setOrderId()
     * @uses ChangeOrderStatus::setStatusWay()
     * @uses ChangeOrderStatus::setStatuses()
     * @uses ChangeOrderStatus::setAuth()
     * @param int $orderId
     * @param string $statusWay
     * @param \ArrayType\ArrayOfStatusChange $statuses
     * @param \StructType\Authentication $auth
     */
    public function __construct($orderId = null, $statusWay = null, \ArrayType\ArrayOfStatusChange $statuses = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setOrderId($orderId)
            ->setStatusWay($statusWay)
            ->setStatuses($statuses)
            ->setAuth($auth);
    }
    /**
     * Get orderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \StructType\ChangeOrderStatus
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get statusWay value
     * @return string|null
     */
    public function getStatusWay()
    {
        return $this->statusWay;
    }
    /**
     * Set statusWay value
     * @param string $statusWay
     * @return \StructType\ChangeOrderStatus
     */
    public function setStatusWay($statusWay = null)
    {
        // validation for constraint: string
        if (!is_null($statusWay) && !is_string($statusWay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusWay, true), gettype($statusWay)), __LINE__);
        }
        $this->statusWay = $statusWay;
        return $this;
    }
    /**
     * Get statuses value
     * @return \ArrayType\ArrayOfStatusChange|null
     */
    public function getStatuses()
    {
        return $this->statuses;
    }
    /**
     * Set statuses value
     * @param \ArrayType\ArrayOfStatusChange $statuses
     * @return \StructType\ChangeOrderStatus
     */
    public function setStatuses(\ArrayType\ArrayOfStatusChange $statuses = null)
    {
        $this->statuses = $statuses;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\ChangeOrderStatus
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeOrderStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
