<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateDeliveOrderId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDeliveOrderId $parameters
     * @return \StructType\UpdateDeliveOrderIdResponse|bool
     */
    public function UpdateDeliveOrderId(\StructType\UpdateDeliveOrderId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateDeliveOrderId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateShopPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateShopPhone $parameters
     * @return \StructType\UpdateShopPhoneResponse|bool
     */
    public function UpdateShopPhone(\StructType\UpdateShopPhone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateShopPhone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateOrderExtended
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateOrderExtended $parameters
     * @return \StructType\UpdateOrderExtendedResponse|bool
     */
    public function UpdateOrderExtended(\StructType\UpdateOrderExtended $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateOrderExtended($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateDeliveOrderIdResponse|\StructType\UpdateOrderExtendedResponse|\StructType\UpdateShopPhoneResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
