<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderGroup StructType
 * @subpackage Structs
 */
class OrderGroup extends AbstractStructBase
{
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderId;
    /**
     * The Statuses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderStatuses
     */
    public $Statuses;
    /**
     * Constructor method for OrderGroup
     * @uses OrderGroup::setOrderId()
     * @uses OrderGroup::setStatuses()
     * @param int $orderId
     * @param \ArrayType\ArrayOfOrderStatuses $statuses
     */
    public function __construct($orderId = null, \ArrayType\ArrayOfOrderStatuses $statuses = null)
    {
        $this
            ->setOrderId($orderId)
            ->setStatuses($statuses);
    }
    /**
     * Get OrderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param int $orderId
     * @return \StructType\OrderGroup
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get Statuses value
     * @return \ArrayType\ArrayOfOrderStatuses|null
     */
    public function getStatuses()
    {
        return $this->Statuses;
    }
    /**
     * Set Statuses value
     * @param \ArrayType\ArrayOfOrderStatuses $statuses
     * @return \StructType\OrderGroup
     */
    public function setStatuses(\ArrayType\ArrayOfOrderStatuses $statuses = null)
    {
        $this->Statuses = $statuses;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
