<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSoldOrderItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfSoldOrderItem extends AbstractStructArrayBase
{
    /**
     * The SoldOrderItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SoldOrderItem[]
     */
    public $SoldOrderItem;
    /**
     * Constructor method for ArrayOfSoldOrderItem
     * @uses ArrayOfSoldOrderItem::setSoldOrderItem()
     * @param \StructType\SoldOrderItem[] $soldOrderItem
     */
    public function __construct(array $soldOrderItem = array())
    {
        $this
            ->setSoldOrderItem($soldOrderItem);
    }
    /**
     * Get SoldOrderItem value
     * @return \StructType\SoldOrderItem[]|null
     */
    public function getSoldOrderItem()
    {
        return $this->SoldOrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setSoldOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSoldOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSoldOrderItemForArrayConstraintsFromSetSoldOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSoldOrderItemSoldOrderItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfSoldOrderItemSoldOrderItemItem instanceof \StructType\SoldOrderItem) {
                $invalidValues[] = is_object($arrayOfSoldOrderItemSoldOrderItemItem) ? get_class($arrayOfSoldOrderItemSoldOrderItemItem) : sprintf('%s(%s)', gettype($arrayOfSoldOrderItemSoldOrderItemItem), var_export($arrayOfSoldOrderItemSoldOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SoldOrderItem property can only contain items of type \StructType\SoldOrderItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SoldOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SoldOrderItem[] $soldOrderItem
     * @return \ArrayType\ArrayOfSoldOrderItem
     */
    public function setSoldOrderItem(array $soldOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($soldOrderItemArrayErrorMessage = self::validateSoldOrderItemForArrayConstraintsFromSetSoldOrderItem($soldOrderItem))) {
            throw new \InvalidArgumentException($soldOrderItemArrayErrorMessage, __LINE__);
        }
        $this->SoldOrderItem = $soldOrderItem;
        return $this;
    }
    /**
     * Add item to SoldOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SoldOrderItem $item
     * @return \ArrayType\ArrayOfSoldOrderItem
     */
    public function addToSoldOrderItem(\StructType\SoldOrderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SoldOrderItem) {
            throw new \InvalidArgumentException(sprintf('The SoldOrderItem property can only contain items of type \StructType\SoldOrderItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SoldOrderItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SoldOrderItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SoldOrderItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SoldOrderItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SoldOrderItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SoldOrderItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SoldOrderItem
     */
    public function getAttributeName()
    {
        return 'SoldOrderItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSoldOrderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
