<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPackage ArrayType
 * @subpackage Arrays
 */
class ArrayOfPackage extends AbstractStructArrayBase
{
    /**
     * The package
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Package[]
     */
    public $package;
    /**
     * Constructor method for ArrayOfPackage
     * @uses ArrayOfPackage::setPackage()
     * @param \StructType\Package[] $package
     */
    public function __construct(array $package = array())
    {
        $this
            ->setPackage($package);
    }
    /**
     * Get package value
     * @return \StructType\Package[]|null
     */
    public function getPackage()
    {
        return $this->package;
    }
    /**
     * This method is responsible for validating the values passed to the setPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageForArrayConstraintsFromSetPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPackagePackageItem) {
            // validation for constraint: itemType
            if (!$arrayOfPackagePackageItem instanceof \StructType\Package) {
                $invalidValues[] = is_object($arrayOfPackagePackageItem) ? get_class($arrayOfPackagePackageItem) : sprintf('%s(%s)', gettype($arrayOfPackagePackageItem), var_export($arrayOfPackagePackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The package property can only contain items of type \StructType\Package, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set package value
     * @throws \InvalidArgumentException
     * @param \StructType\Package[] $package
     * @return \ArrayType\ArrayOfPackage
     */
    public function setPackage(array $package = array())
    {
        // validation for constraint: array
        if ('' !== ($packageArrayErrorMessage = self::validatePackageForArrayConstraintsFromSetPackage($package))) {
            throw new \InvalidArgumentException($packageArrayErrorMessage, __LINE__);
        }
        $this->package = $package;
        return $this;
    }
    /**
     * Add item to package value
     * @throws \InvalidArgumentException
     * @param \StructType\Package $item
     * @return \ArrayType\ArrayOfPackage
     */
    public function addToPackage(\StructType\Package $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Package) {
            throw new \InvalidArgumentException(sprintf('The package property can only contain items of type \StructType\Package, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->package[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Package|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Package|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Package|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Package|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Package|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string package
     */
    public function getAttributeName()
    {
        return 'package';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
