<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PieceBarcode StructType
 * @subpackage Structs
 */
class PieceBarcode extends AbstractStructBase
{
    /**
     * The piece
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $piece;
    /**
     * The barcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $barcode;
    /**
     * Constructor method for PieceBarcode
     * @uses PieceBarcode::setPiece()
     * @uses PieceBarcode::setBarcode()
     * @param int $piece
     * @param string $barcode
     */
    public function __construct($piece = null, $barcode = null)
    {
        $this
            ->setPiece($piece)
            ->setBarcode($barcode);
    }
    /**
     * Get piece value
     * @return int
     */
    public function getPiece()
    {
        return $this->piece;
    }
    /**
     * Set piece value
     * @param int $piece
     * @return \StructType\PieceBarcode
     */
    public function setPiece($piece = null)
    {
        // validation for constraint: int
        if (!is_null($piece) && !(is_int($piece) || ctype_digit($piece))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($piece, true), gettype($piece)), __LINE__);
        }
        $this->piece = $piece;
        return $this;
    }
    /**
     * Get barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->barcode;
    }
    /**
     * Set barcode value
     * @param string $barcode
     * @return \StructType\PieceBarcode
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->barcode = $barcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PieceBarcode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
