<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for responseCreatePickingTask StructType
 * @subpackage Structs
 */
class ResponseCreatePickingTask extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $errors;
    /**
     * The warnings
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $warnings;
    /**
     * Constructor method for responseCreatePickingTask
     * @uses ResponseCreatePickingTask::setId()
     * @uses ResponseCreatePickingTask::setErrors()
     * @uses ResponseCreatePickingTask::setWarnings()
     * @param string $id
     * @param string[] $errors
     * @param string[] $warnings
     */
    public function __construct($id = null, array $errors = array(), array $warnings = array())
    {
        $this
            ->setId($id)
            ->setErrors($errors)
            ->setWarnings($warnings);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ResponseCreatePickingTask
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get errors value
     * @return string[]|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * This method is responsible for validating the values passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorsForArrayConstraintsFromSetErrors(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseCreatePickingTaskErrorsItem) {
            // validation for constraint: itemType
            if (!is_string($responseCreatePickingTaskErrorsItem)) {
                $invalidValues[] = is_object($responseCreatePickingTaskErrorsItem) ? get_class($responseCreatePickingTaskErrorsItem) : sprintf('%s(%s)', gettype($responseCreatePickingTaskErrorsItem), var_export($responseCreatePickingTaskErrorsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The errors property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set errors value
     * @throws \InvalidArgumentException
     * @param string[] $errors
     * @return \StructType\ResponseCreatePickingTask
     */
    public function setErrors(array $errors = array())
    {
        // validation for constraint: array
        if ('' !== ($errorsArrayErrorMessage = self::validateErrorsForArrayConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsArrayErrorMessage, __LINE__);
        }
        $this->errors = $errors;
        return $this;
    }
    /**
     * Add item to errors value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ResponseCreatePickingTask
     */
    public function addToErrors($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The errors property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->errors[] = $item;
        return $this;
    }
    /**
     * Get warnings value
     * @return string[]|null
     */
    public function getWarnings()
    {
        return $this->warnings;
    }
    /**
     * This method is responsible for validating the values passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningsForArrayConstraintsFromSetWarnings(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseCreatePickingTaskWarningsItem) {
            // validation for constraint: itemType
            if (!is_string($responseCreatePickingTaskWarningsItem)) {
                $invalidValues[] = is_object($responseCreatePickingTaskWarningsItem) ? get_class($responseCreatePickingTaskWarningsItem) : sprintf('%s(%s)', gettype($responseCreatePickingTaskWarningsItem), var_export($responseCreatePickingTaskWarningsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The warnings property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set warnings value
     * @throws \InvalidArgumentException
     * @param string[] $warnings
     * @return \StructType\ResponseCreatePickingTask
     */
    public function setWarnings(array $warnings = array())
    {
        // validation for constraint: array
        if ('' !== ($warningsArrayErrorMessage = self::validateWarningsForArrayConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsArrayErrorMessage, __LINE__);
        }
        $this->warnings = $warnings;
        return $this;
    }
    /**
     * Add item to warnings value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ResponseCreatePickingTask
     */
    public function addToWarnings($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The warnings property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->warnings[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponseCreatePickingTask
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
