<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Refuse ServiceType
 * @subpackage Services
 */
class Refuse extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RefuseOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RefuseOrder $parameters
     * @return \StructType\RefuseOrderResponse|bool
     */
    public function RefuseOrder(\StructType\RefuseOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RefuseOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RefuseOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
