<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order StructType
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderId;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CompleteDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CompleteDate;
    /**
     * The SettingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SettingId;
    /**
     * The SourcePlaceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourcePlaceId;
    /**
     * The DeliveryPlaceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeliveryPlaceId;
    /**
     * The SelfDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SelfDelivery;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Weight;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Volume;
    /**
     * The PiecesOfFreight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PiecesOfFreight;
    /**
     * The TotalCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalCost;
    /**
     * The DeliveryCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DeliveryCost;
    /**
     * The IsPartialGiveoutDisabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPartialGiveoutDisabled;
    /**
     * The AssessedCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AssessedCost;
    /**
     * The PayType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayType;
    /**
     * The DesiredDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DesiredDeliveryDate;
    /**
     * The NDSDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NDSDelivery;
    /**
     * The OrderIdImport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderIdImport;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDeliveredOrderItem
     */
    public $Items;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\User
     */
    public $User;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The ShipmentWHDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentWHDate;
    /**
     * The TimeDeliveryFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeDeliveryFrom;
    /**
     * The TimeDeliveryTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeDeliveryTo;
    /**
     * The StockId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StockId;
    /**
     * The LiftingIsPayed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $LiftingIsPayed;
    /**
     * The PaymentMethodOfLifting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PaymentMethodOfLifting;
    /**
     * The PrepaymentAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PrepaymentAmount;
    /**
     * The barcodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPieceBarcode
     */
    public $barcodes;
    /**
     * The DeliveryThisDay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveryThisDay;
    /**
     * Constructor method for Order
     * @uses Order::setOrderId()
     * @uses Order::setCreateDate()
     * @uses Order::setCompleteDate()
     * @uses Order::setSettingId()
     * @uses Order::setSourcePlaceId()
     * @uses Order::setDeliveryPlaceId()
     * @uses Order::setSelfDelivery()
     * @uses Order::setWeight()
     * @uses Order::setVolume()
     * @uses Order::setPiecesOfFreight()
     * @uses Order::setTotalCost()
     * @uses Order::setDeliveryCost()
     * @uses Order::setIsPartialGiveoutDisabled()
     * @uses Order::setAssessedCost()
     * @uses Order::setPayType()
     * @uses Order::setDesiredDeliveryDate()
     * @uses Order::setNDSDelivery()
     * @uses Order::setOrderIdImport()
     * @uses Order::setItems()
     * @uses Order::setUser()
     * @uses Order::setAddress()
     * @uses Order::setComment()
     * @uses Order::setShipmentWHDate()
     * @uses Order::setTimeDeliveryFrom()
     * @uses Order::setTimeDeliveryTo()
     * @uses Order::setStockId()
     * @uses Order::setLiftingIsPayed()
     * @uses Order::setPaymentMethodOfLifting()
     * @uses Order::setPrepaymentAmount()
     * @uses Order::setBarcodes()
     * @uses Order::setDeliveryThisDay()
     * @param int $orderId
     * @param string $createDate
     * @param string $completeDate
     * @param int $settingId
     * @param int $sourcePlaceId
     * @param int $deliveryPlaceId
     * @param int $selfDelivery
     * @param float $weight
     * @param float $volume
     * @param int $piecesOfFreight
     * @param float $totalCost
     * @param float $deliveryCost
     * @param bool $isPartialGiveoutDisabled
     * @param float $assessedCost
     * @param int $payType
     * @param string $desiredDeliveryDate
     * @param int $nDSDelivery
     * @param string $orderIdImport
     * @param \ArrayType\ArrayOfDeliveredOrderItem $items
     * @param \StructType\User $user
     * @param \StructType\Address $address
     * @param string $comment
     * @param string $shipmentWHDate
     * @param string $timeDeliveryFrom
     * @param string $timeDeliveryTo
     * @param string $stockId
     * @param bool $liftingIsPayed
     * @param int $paymentMethodOfLifting
     * @param float $prepaymentAmount
     * @param \ArrayType\ArrayOfPieceBarcode $barcodes
     * @param int $deliveryThisDay
     */
    public function __construct($orderId = null, $createDate = null, $completeDate = null, $settingId = null, $sourcePlaceId = null, $deliveryPlaceId = null, $selfDelivery = null, $weight = null, $volume = null, $piecesOfFreight = null, $totalCost = null, $deliveryCost = null, $isPartialGiveoutDisabled = null, $assessedCost = null, $payType = null, $desiredDeliveryDate = null, $nDSDelivery = null, $orderIdImport = null, \ArrayType\ArrayOfDeliveredOrderItem $items = null, \StructType\User $user = null, \StructType\Address $address = null, $comment = null, $shipmentWHDate = null, $timeDeliveryFrom = null, $timeDeliveryTo = null, $stockId = null, $liftingIsPayed = null, $paymentMethodOfLifting = null, $prepaymentAmount = null, \ArrayType\ArrayOfPieceBarcode $barcodes = null, $deliveryThisDay = null)
    {
        $this
            ->setOrderId($orderId)
            ->setCreateDate($createDate)
            ->setCompleteDate($completeDate)
            ->setSettingId($settingId)
            ->setSourcePlaceId($sourcePlaceId)
            ->setDeliveryPlaceId($deliveryPlaceId)
            ->setSelfDelivery($selfDelivery)
            ->setWeight($weight)
            ->setVolume($volume)
            ->setPiecesOfFreight($piecesOfFreight)
            ->setTotalCost($totalCost)
            ->setDeliveryCost($deliveryCost)
            ->setIsPartialGiveoutDisabled($isPartialGiveoutDisabled)
            ->setAssessedCost($assessedCost)
            ->setPayType($payType)
            ->setDesiredDeliveryDate($desiredDeliveryDate)
            ->setNDSDelivery($nDSDelivery)
            ->setOrderIdImport($orderIdImport)
            ->setItems($items)
            ->setUser($user)
            ->setAddress($address)
            ->setComment($comment)
            ->setShipmentWHDate($shipmentWHDate)
            ->setTimeDeliveryFrom($timeDeliveryFrom)
            ->setTimeDeliveryTo($timeDeliveryTo)
            ->setStockId($stockId)
            ->setLiftingIsPayed($liftingIsPayed)
            ->setPaymentMethodOfLifting($paymentMethodOfLifting)
            ->setPrepaymentAmount($prepaymentAmount)
            ->setBarcodes($barcodes)
            ->setDeliveryThisDay($deliveryThisDay);
    }
    /**
     * Get OrderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param int $orderId
     * @return \StructType\Order
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\Order
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CompleteDate value
     * @return string
     */
    public function getCompleteDate()
    {
        return $this->CompleteDate;
    }
    /**
     * Set CompleteDate value
     * @param string $completeDate
     * @return \StructType\Order
     */
    public function setCompleteDate($completeDate = null)
    {
        // validation for constraint: string
        if (!is_null($completeDate) && !is_string($completeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completeDate, true), gettype($completeDate)), __LINE__);
        }
        $this->CompleteDate = $completeDate;
        return $this;
    }
    /**
     * Get SettingId value
     * @return int
     */
    public function getSettingId()
    {
        return $this->SettingId;
    }
    /**
     * Set SettingId value
     * @param int $settingId
     * @return \StructType\Order
     */
    public function setSettingId($settingId = null)
    {
        // validation for constraint: int
        if (!is_null($settingId) && !(is_int($settingId) || ctype_digit($settingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($settingId, true), gettype($settingId)), __LINE__);
        }
        $this->SettingId = $settingId;
        return $this;
    }
    /**
     * Get SourcePlaceId value
     * @return int
     */
    public function getSourcePlaceId()
    {
        return $this->SourcePlaceId;
    }
    /**
     * Set SourcePlaceId value
     * @param int $sourcePlaceId
     * @return \StructType\Order
     */
    public function setSourcePlaceId($sourcePlaceId = null)
    {
        // validation for constraint: int
        if (!is_null($sourcePlaceId) && !(is_int($sourcePlaceId) || ctype_digit($sourcePlaceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourcePlaceId, true), gettype($sourcePlaceId)), __LINE__);
        }
        $this->SourcePlaceId = $sourcePlaceId;
        return $this;
    }
    /**
     * Get DeliveryPlaceId value
     * @return int
     */
    public function getDeliveryPlaceId()
    {
        return $this->DeliveryPlaceId;
    }
    /**
     * Set DeliveryPlaceId value
     * @param int $deliveryPlaceId
     * @return \StructType\Order
     */
    public function setDeliveryPlaceId($deliveryPlaceId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryPlaceId) && !(is_int($deliveryPlaceId) || ctype_digit($deliveryPlaceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryPlaceId, true), gettype($deliveryPlaceId)), __LINE__);
        }
        $this->DeliveryPlaceId = $deliveryPlaceId;
        return $this;
    }
    /**
     * Get SelfDelivery value
     * @return int
     */
    public function getSelfDelivery()
    {
        return $this->SelfDelivery;
    }
    /**
     * Set SelfDelivery value
     * @param int $selfDelivery
     * @return \StructType\Order
     */
    public function setSelfDelivery($selfDelivery = null)
    {
        // validation for constraint: int
        if (!is_null($selfDelivery) && !(is_int($selfDelivery) || ctype_digit($selfDelivery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selfDelivery, true), gettype($selfDelivery)), __LINE__);
        }
        $this->SelfDelivery = $selfDelivery;
        return $this;
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\Order
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Volume value
     * @return float
     */
    public function getVolume()
    {
        return $this->Volume;
    }
    /**
     * Set Volume value
     * @param float $volume
     * @return \StructType\Order
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        $this->Volume = $volume;
        return $this;
    }
    /**
     * Get PiecesOfFreight value
     * @return int
     */
    public function getPiecesOfFreight()
    {
        return $this->PiecesOfFreight;
    }
    /**
     * Set PiecesOfFreight value
     * @param int $piecesOfFreight
     * @return \StructType\Order
     */
    public function setPiecesOfFreight($piecesOfFreight = null)
    {
        // validation for constraint: int
        if (!is_null($piecesOfFreight) && !(is_int($piecesOfFreight) || ctype_digit($piecesOfFreight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($piecesOfFreight, true), gettype($piecesOfFreight)), __LINE__);
        }
        $this->PiecesOfFreight = $piecesOfFreight;
        return $this;
    }
    /**
     * Get TotalCost value
     * @return float
     */
    public function getTotalCost()
    {
        return $this->TotalCost;
    }
    /**
     * Set TotalCost value
     * @param float $totalCost
     * @return \StructType\Order
     */
    public function setTotalCost($totalCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalCost) && !(is_float($totalCost) || is_numeric($totalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCost, true), gettype($totalCost)), __LINE__);
        }
        $this->TotalCost = $totalCost;
        return $this;
    }
    /**
     * Get DeliveryCost value
     * @return float
     */
    public function getDeliveryCost()
    {
        return $this->DeliveryCost;
    }
    /**
     * Set DeliveryCost value
     * @param float $deliveryCost
     * @return \StructType\Order
     */
    public function setDeliveryCost($deliveryCost = null)
    {
        // validation for constraint: float
        if (!is_null($deliveryCost) && !(is_float($deliveryCost) || is_numeric($deliveryCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deliveryCost, true), gettype($deliveryCost)), __LINE__);
        }
        $this->DeliveryCost = $deliveryCost;
        return $this;
    }
    /**
     * Get IsPartialGiveoutDisabled value
     * @return bool
     */
    public function getIsPartialGiveoutDisabled()
    {
        return $this->IsPartialGiveoutDisabled;
    }
    /**
     * Set IsPartialGiveoutDisabled value
     * @param bool $isPartialGiveoutDisabled
     * @return \StructType\Order
     */
    public function setIsPartialGiveoutDisabled($isPartialGiveoutDisabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartialGiveoutDisabled) && !is_bool($isPartialGiveoutDisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartialGiveoutDisabled, true), gettype($isPartialGiveoutDisabled)), __LINE__);
        }
        $this->IsPartialGiveoutDisabled = $isPartialGiveoutDisabled;
        return $this;
    }
    /**
     * Get AssessedCost value
     * @return float
     */
    public function getAssessedCost()
    {
        return $this->AssessedCost;
    }
    /**
     * Set AssessedCost value
     * @param float $assessedCost
     * @return \StructType\Order
     */
    public function setAssessedCost($assessedCost = null)
    {
        // validation for constraint: float
        if (!is_null($assessedCost) && !(is_float($assessedCost) || is_numeric($assessedCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($assessedCost, true), gettype($assessedCost)), __LINE__);
        }
        $this->AssessedCost = $assessedCost;
        return $this;
    }
    /**
     * Get PayType value
     * @return int
     */
    public function getPayType()
    {
        return $this->PayType;
    }
    /**
     * Set PayType value
     * @param int $payType
     * @return \StructType\Order
     */
    public function setPayType($payType = null)
    {
        // validation for constraint: int
        if (!is_null($payType) && !(is_int($payType) || ctype_digit($payType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payType, true), gettype($payType)), __LINE__);
        }
        $this->PayType = $payType;
        return $this;
    }
    /**
     * Get DesiredDeliveryDate value
     * @return string
     */
    public function getDesiredDeliveryDate()
    {
        return $this->DesiredDeliveryDate;
    }
    /**
     * Set DesiredDeliveryDate value
     * @param string $desiredDeliveryDate
     * @return \StructType\Order
     */
    public function setDesiredDeliveryDate($desiredDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($desiredDeliveryDate) && !is_string($desiredDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desiredDeliveryDate, true), gettype($desiredDeliveryDate)), __LINE__);
        }
        $this->DesiredDeliveryDate = $desiredDeliveryDate;
        return $this;
    }
    /**
     * Get NDSDelivery value
     * @return int
     */
    public function getNDSDelivery()
    {
        return $this->NDSDelivery;
    }
    /**
     * Set NDSDelivery value
     * @param int $nDSDelivery
     * @return \StructType\Order
     */
    public function setNDSDelivery($nDSDelivery = null)
    {
        // validation for constraint: int
        if (!is_null($nDSDelivery) && !(is_int($nDSDelivery) || ctype_digit($nDSDelivery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nDSDelivery, true), gettype($nDSDelivery)), __LINE__);
        }
        $this->NDSDelivery = $nDSDelivery;
        return $this;
    }
    /**
     * Get OrderIdImport value
     * @return string|null
     */
    public function getOrderIdImport()
    {
        return $this->OrderIdImport;
    }
    /**
     * Set OrderIdImport value
     * @param string $orderIdImport
     * @return \StructType\Order
     */
    public function setOrderIdImport($orderIdImport = null)
    {
        // validation for constraint: string
        if (!is_null($orderIdImport) && !is_string($orderIdImport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderIdImport, true), gettype($orderIdImport)), __LINE__);
        }
        $this->OrderIdImport = $orderIdImport;
        return $this;
    }
    /**
     * Get Items value
     * @return \ArrayType\ArrayOfDeliveredOrderItem|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \ArrayType\ArrayOfDeliveredOrderItem $items
     * @return \StructType\Order
     */
    public function setItems(\ArrayType\ArrayOfDeliveredOrderItem $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get User value
     * @return \StructType\User|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \StructType\User $user
     * @return \StructType\Order
     */
    public function setUser(\StructType\User $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\Order
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Order
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get ShipmentWHDate value
     * @return string|null
     */
    public function getShipmentWHDate()
    {
        return $this->ShipmentWHDate;
    }
    /**
     * Set ShipmentWHDate value
     * @param string $shipmentWHDate
     * @return \StructType\Order
     */
    public function setShipmentWHDate($shipmentWHDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentWHDate) && !is_string($shipmentWHDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentWHDate, true), gettype($shipmentWHDate)), __LINE__);
        }
        $this->ShipmentWHDate = $shipmentWHDate;
        return $this;
    }
    /**
     * Get TimeDeliveryFrom value
     * @return string|null
     */
    public function getTimeDeliveryFrom()
    {
        return $this->TimeDeliveryFrom;
    }
    /**
     * Set TimeDeliveryFrom value
     * @param string $timeDeliveryFrom
     * @return \StructType\Order
     */
    public function setTimeDeliveryFrom($timeDeliveryFrom = null)
    {
        // validation for constraint: string
        if (!is_null($timeDeliveryFrom) && !is_string($timeDeliveryFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDeliveryFrom, true), gettype($timeDeliveryFrom)), __LINE__);
        }
        $this->TimeDeliveryFrom = $timeDeliveryFrom;
        return $this;
    }
    /**
     * Get TimeDeliveryTo value
     * @return string|null
     */
    public function getTimeDeliveryTo()
    {
        return $this->TimeDeliveryTo;
    }
    /**
     * Set TimeDeliveryTo value
     * @param string $timeDeliveryTo
     * @return \StructType\Order
     */
    public function setTimeDeliveryTo($timeDeliveryTo = null)
    {
        // validation for constraint: string
        if (!is_null($timeDeliveryTo) && !is_string($timeDeliveryTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDeliveryTo, true), gettype($timeDeliveryTo)), __LINE__);
        }
        $this->TimeDeliveryTo = $timeDeliveryTo;
        return $this;
    }
    /**
     * Get StockId value
     * @return string|null
     */
    public function getStockId()
    {
        return $this->StockId;
    }
    /**
     * Set StockId value
     * @param string $stockId
     * @return \StructType\Order
     */
    public function setStockId($stockId = null)
    {
        // validation for constraint: string
        if (!is_null($stockId) && !is_string($stockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockId, true), gettype($stockId)), __LINE__);
        }
        $this->StockId = $stockId;
        return $this;
    }
    /**
     * Get LiftingIsPayed value
     * @return bool|null
     */
    public function getLiftingIsPayed()
    {
        return $this->LiftingIsPayed;
    }
    /**
     * Set LiftingIsPayed value
     * @param bool $liftingIsPayed
     * @return \StructType\Order
     */
    public function setLiftingIsPayed($liftingIsPayed = null)
    {
        // validation for constraint: boolean
        if (!is_null($liftingIsPayed) && !is_bool($liftingIsPayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($liftingIsPayed, true), gettype($liftingIsPayed)), __LINE__);
        }
        $this->LiftingIsPayed = $liftingIsPayed;
        return $this;
    }
    /**
     * Get PaymentMethodOfLifting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPaymentMethodOfLifting()
    {
        return isset($this->PaymentMethodOfLifting) ? $this->PaymentMethodOfLifting : null;
    }
    /**
     * Set PaymentMethodOfLifting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $paymentMethodOfLifting
     * @return \StructType\Order
     */
    public function setPaymentMethodOfLifting($paymentMethodOfLifting = null)
    {
        // validation for constraint: int
        if (!is_null($paymentMethodOfLifting) && !(is_int($paymentMethodOfLifting) || ctype_digit($paymentMethodOfLifting))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentMethodOfLifting, true), gettype($paymentMethodOfLifting)), __LINE__);
        }
        if (is_null($paymentMethodOfLifting) || (is_array($paymentMethodOfLifting) && empty($paymentMethodOfLifting))) {
            unset($this->PaymentMethodOfLifting);
        } else {
            $this->PaymentMethodOfLifting = $paymentMethodOfLifting;
        }
        return $this;
    }
    /**
     * Get PrepaymentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrepaymentAmount()
    {
        return isset($this->PrepaymentAmount) ? $this->PrepaymentAmount : null;
    }
    /**
     * Set PrepaymentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prepaymentAmount
     * @return \StructType\Order
     */
    public function setPrepaymentAmount($prepaymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($prepaymentAmount) && !(is_float($prepaymentAmount) || is_numeric($prepaymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prepaymentAmount, true), gettype($prepaymentAmount)), __LINE__);
        }
        if (is_null($prepaymentAmount) || (is_array($prepaymentAmount) && empty($prepaymentAmount))) {
            unset($this->PrepaymentAmount);
        } else {
            $this->PrepaymentAmount = $prepaymentAmount;
        }
        return $this;
    }
    /**
     * Get barcodes value
     * @return \ArrayType\ArrayOfPieceBarcode|null
     */
    public function getBarcodes()
    {
        return $this->barcodes;
    }
    /**
     * Set barcodes value
     * @param \ArrayType\ArrayOfPieceBarcode $barcodes
     * @return \StructType\Order
     */
    public function setBarcodes(\ArrayType\ArrayOfPieceBarcode $barcodes = null)
    {
        $this->barcodes = $barcodes;
        return $this;
    }
    /**
     * Get DeliveryThisDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveryThisDay()
    {
        return isset($this->DeliveryThisDay) ? $this->DeliveryThisDay : null;
    }
    /**
     * Set DeliveryThisDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveryThisDay
     * @return \StructType\Order
     */
    public function setDeliveryThisDay($deliveryThisDay = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryThisDay) && !(is_int($deliveryThisDay) || ctype_digit($deliveryThisDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryThisDay, true), gettype($deliveryThisDay)), __LINE__);
        }
        if (is_null($deliveryThisDay) || (is_array($deliveryThisDay) && empty($deliveryThisDay))) {
            unset($this->DeliveryThisDay);
        } else {
            $this->DeliveryThisDay = $deliveryThisDay;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Order
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
