<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderStatuses StructType
 * @subpackage Structs
 */
class OrderStatuses extends AbstractStructBase
{
    /**
     * The StatusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusId;
    /**
     * The FinalStatusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FinalStatusId;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The TimeStamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TimeStamp;
    /**
     * The ProcessingTerminal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ProcessingTerminal;
    /**
     * The Initiator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Initiator;
    /**
     * Constructor method for OrderStatuses
     * @uses OrderStatuses::setStatusId()
     * @uses OrderStatuses::setFinalStatusId()
     * @uses OrderStatuses::setDate()
     * @uses OrderStatuses::setTimeStamp()
     * @uses OrderStatuses::setProcessingTerminal()
     * @uses OrderStatuses::setInitiator()
     * @param int $statusId
     * @param int $finalStatusId
     * @param string $date
     * @param string $timeStamp
     * @param int $processingTerminal
     * @param int $initiator
     */
    public function __construct($statusId = null, $finalStatusId = null, $date = null, $timeStamp = null, $processingTerminal = null, $initiator = null)
    {
        $this
            ->setStatusId($statusId)
            ->setFinalStatusId($finalStatusId)
            ->setDate($date)
            ->setTimeStamp($timeStamp)
            ->setProcessingTerminal($processingTerminal)
            ->setInitiator($initiator);
    }
    /**
     * Get StatusId value
     * @return int
     */
    public function getStatusId()
    {
        return $this->StatusId;
    }
    /**
     * Set StatusId value
     * @param int $statusId
     * @return \StructType\OrderStatuses
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: int
        if (!is_null($statusId) && !(is_int($statusId) || ctype_digit($statusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusId, true), gettype($statusId)), __LINE__);
        }
        $this->StatusId = $statusId;
        return $this;
    }
    /**
     * Get FinalStatusId value
     * @return int
     */
    public function getFinalStatusId()
    {
        return $this->FinalStatusId;
    }
    /**
     * Set FinalStatusId value
     * @param int $finalStatusId
     * @return \StructType\OrderStatuses
     */
    public function setFinalStatusId($finalStatusId = null)
    {
        // validation for constraint: int
        if (!is_null($finalStatusId) && !(is_int($finalStatusId) || ctype_digit($finalStatusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($finalStatusId, true), gettype($finalStatusId)), __LINE__);
        }
        $this->FinalStatusId = $finalStatusId;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\OrderStatuses
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OrderStatuses
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get ProcessingTerminal value
     * @return int
     */
    public function getProcessingTerminal()
    {
        return $this->ProcessingTerminal;
    }
    /**
     * Set ProcessingTerminal value
     * @param int $processingTerminal
     * @return \StructType\OrderStatuses
     */
    public function setProcessingTerminal($processingTerminal = null)
    {
        // validation for constraint: int
        if (!is_null($processingTerminal) && !(is_int($processingTerminal) || ctype_digit($processingTerminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processingTerminal, true), gettype($processingTerminal)), __LINE__);
        }
        $this->ProcessingTerminal = $processingTerminal;
        return $this;
    }
    /**
     * Get Initiator value
     * @return int
     */
    public function getInitiator()
    {
        return $this->Initiator;
    }
    /**
     * Set Initiator value
     * @param int $initiator
     * @return \StructType\OrderStatuses
     */
    public function setInitiator($initiator = null)
    {
        // validation for constraint: int
        if (!is_null($initiator) && !(is_int($initiator) || ctype_digit($initiator))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($initiator, true), gettype($initiator)), __LINE__);
        }
        $this->Initiator = $initiator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderStatuses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
