<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItem StructType
 * @subpackage Structs
 */
class OrderItem extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Count;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The PriceZak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PriceZak;
    /**
     * The orderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderID;
    /**
     * The dimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $dimension;
    /**
     * The mass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $mass;
    /**
     * The categoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $categoryId;
    /**
     * The rootCategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $rootCategoryId;
    /**
     * The deliveryTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $deliveryTypeId;
    /**
     * The rateVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $rateVAT;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The sku
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * Constructor method for OrderItem
     * @uses OrderItem::setId()
     * @uses OrderItem::setCount()
     * @uses OrderItem::setPrice()
     * @uses OrderItem::setPriceZak()
     * @uses OrderItem::setOrderID()
     * @uses OrderItem::setDimension()
     * @uses OrderItem::setMass()
     * @uses OrderItem::setCategoryId()
     * @uses OrderItem::setRootCategoryId()
     * @uses OrderItem::setDeliveryTypeId()
     * @uses OrderItem::setRateVAT()
     * @uses OrderItem::setName()
     * @uses OrderItem::setSku()
     * @uses OrderItem::setCode()
     * @param int $id
     * @param int $count
     * @param float $price
     * @param float $priceZak
     * @param int $orderID
     * @param float $dimension
     * @param float $mass
     * @param int $categoryId
     * @param int $rootCategoryId
     * @param int $deliveryTypeId
     * @param float $rateVAT
     * @param string $name
     * @param string $sku
     * @param string $code
     */
    public function __construct($id = null, $count = null, $price = null, $priceZak = null, $orderID = null, $dimension = null, $mass = null, $categoryId = null, $rootCategoryId = null, $deliveryTypeId = null, $rateVAT = null, $name = null, $sku = null, $code = null)
    {
        $this
            ->setId($id)
            ->setCount($count)
            ->setPrice($price)
            ->setPriceZak($priceZak)
            ->setOrderID($orderID)
            ->setDimension($dimension)
            ->setMass($mass)
            ->setCategoryId($categoryId)
            ->setRootCategoryId($rootCategoryId)
            ->setDeliveryTypeId($deliveryTypeId)
            ->setRateVAT($rateVAT)
            ->setName($name)
            ->setSku($sku)
            ->setCode($code);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\OrderItem
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Count value
     * @return int
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\OrderItem
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\OrderItem
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PriceZak value
     * @return float
     */
    public function getPriceZak()
    {
        return $this->PriceZak;
    }
    /**
     * Set PriceZak value
     * @param float $priceZak
     * @return \StructType\OrderItem
     */
    public function setPriceZak($priceZak = null)
    {
        // validation for constraint: float
        if (!is_null($priceZak) && !(is_float($priceZak) || is_numeric($priceZak))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceZak, true), gettype($priceZak)), __LINE__);
        }
        $this->PriceZak = $priceZak;
        return $this;
    }
    /**
     * Get orderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->orderID;
    }
    /**
     * Set orderID value
     * @param int $orderID
     * @return \StructType\OrderItem
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->orderID = $orderID;
        return $this;
    }
    /**
     * Get dimension value
     * @return float
     */
    public function getDimension()
    {
        return $this->dimension;
    }
    /**
     * Set dimension value
     * @param float $dimension
     * @return \StructType\OrderItem
     */
    public function setDimension($dimension = null)
    {
        // validation for constraint: float
        if (!is_null($dimension) && !(is_float($dimension) || is_numeric($dimension))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dimension, true), gettype($dimension)), __LINE__);
        }
        $this->dimension = $dimension;
        return $this;
    }
    /**
     * Get mass value
     * @return float
     */
    public function getMass()
    {
        return $this->mass;
    }
    /**
     * Set mass value
     * @param float $mass
     * @return \StructType\OrderItem
     */
    public function setMass($mass = null)
    {
        // validation for constraint: float
        if (!is_null($mass) && !(is_float($mass) || is_numeric($mass))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mass, true), gettype($mass)), __LINE__);
        }
        $this->mass = $mass;
        return $this;
    }
    /**
     * Get categoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    /**
     * Set categoryId value
     * @param int $categoryId
     * @return \StructType\OrderItem
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->categoryId = $categoryId;
        return $this;
    }
    /**
     * Get rootCategoryId value
     * @return int
     */
    public function getRootCategoryId()
    {
        return $this->rootCategoryId;
    }
    /**
     * Set rootCategoryId value
     * @param int $rootCategoryId
     * @return \StructType\OrderItem
     */
    public function setRootCategoryId($rootCategoryId = null)
    {
        // validation for constraint: int
        if (!is_null($rootCategoryId) && !(is_int($rootCategoryId) || ctype_digit($rootCategoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rootCategoryId, true), gettype($rootCategoryId)), __LINE__);
        }
        $this->rootCategoryId = $rootCategoryId;
        return $this;
    }
    /**
     * Get deliveryTypeId value
     * @return int
     */
    public function getDeliveryTypeId()
    {
        return $this->deliveryTypeId;
    }
    /**
     * Set deliveryTypeId value
     * @param int $deliveryTypeId
     * @return \StructType\OrderItem
     */
    public function setDeliveryTypeId($deliveryTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryTypeId) && !(is_int($deliveryTypeId) || ctype_digit($deliveryTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryTypeId, true), gettype($deliveryTypeId)), __LINE__);
        }
        $this->deliveryTypeId = $deliveryTypeId;
        return $this;
    }
    /**
     * Get rateVAT value
     * @return float
     */
    public function getRateVAT()
    {
        return $this->rateVAT;
    }
    /**
     * Set rateVAT value
     * @param float $rateVAT
     * @return \StructType\OrderItem
     */
    public function setRateVAT($rateVAT = null)
    {
        // validation for constraint: float
        if (!is_null($rateVAT) && !(is_float($rateVAT) || is_numeric($rateVAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rateVAT, true), gettype($rateVAT)), __LINE__);
        }
        $this->rateVAT = $rateVAT;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\OrderItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \StructType\OrderItem
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sku, true), gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\OrderItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
