<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateWarehouseResponse StructType
 * @subpackage Structs
 */
class UpdateWarehouseResponse extends Response
{
    /**
     * The StockId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $StockId;
    /**
     * The UpdateWarehouseResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UpdateWarehouseResponse
     */
    public $UpdateWarehouseResult;
    /**
     * Constructor method for UpdateWarehouseResponse
     * @uses UpdateWarehouseResponse::setStockId()
     * @uses UpdateWarehouseResponse::setUpdateWarehouseResult()
     * @param int $stockId
     * @param \StructType\UpdateWarehouseResponse $updateWarehouseResult
     */
    public function __construct($stockId = null, \StructType\UpdateWarehouseResponse $updateWarehouseResult = null)
    {
        $this
            ->setStockId($stockId)
            ->setUpdateWarehouseResult($updateWarehouseResult);
    }
    /**
     * Get StockId value
     * @return int
     */
    public function getStockId()
    {
        return $this->StockId;
    }
    /**
     * Set StockId value
     * @param int $stockId
     * @return \StructType\UpdateWarehouseResponse
     */
    public function setStockId($stockId = null)
    {
        // validation for constraint: int
        if (!is_null($stockId) && !(is_int($stockId) || ctype_digit($stockId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stockId, true), gettype($stockId)), __LINE__);
        }
        $this->StockId = $stockId;
        return $this;
    }
    /**
     * Get UpdateWarehouseResult value
     * @return \StructType\UpdateWarehouseResponse|null
     */
    public function getUpdateWarehouseResult()
    {
        return $this->UpdateWarehouseResult;
    }
    /**
     * Set UpdateWarehouseResult value
     * @param \StructType\UpdateWarehouseResponse $updateWarehouseResult
     * @return \StructType\UpdateWarehouseResponse
     */
    public function setUpdateWarehouseResult(\StructType\UpdateWarehouseResponse $updateWarehouseResult = null)
    {
        $this->UpdateWarehouseResult = $updateWarehouseResult;
        return $this;
    }
}
