<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCarriage StructType
 * @subpackage Structs
 */
class AddCarriage extends AbstractStructBase
{
    /**
     * The settingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $settingId;
    /**
     * The carriage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Carriage
     */
    public $carriage;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for AddCarriage
     * @uses AddCarriage::setSettingId()
     * @uses AddCarriage::setCarriage()
     * @uses AddCarriage::setAuth()
     * @param int $settingId
     * @param \StructType\Carriage $carriage
     * @param \StructType\Authentication $auth
     */
    public function __construct($settingId = null, \StructType\Carriage $carriage = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setSettingId($settingId)
            ->setCarriage($carriage)
            ->setAuth($auth);
    }
    /**
     * Get settingId value
     * @return int
     */
    public function getSettingId()
    {
        return $this->settingId;
    }
    /**
     * Set settingId value
     * @param int $settingId
     * @return \StructType\AddCarriage
     */
    public function setSettingId($settingId = null)
    {
        // validation for constraint: int
        if (!is_null($settingId) && !(is_int($settingId) || ctype_digit($settingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($settingId, true), gettype($settingId)), __LINE__);
        }
        $this->settingId = $settingId;
        return $this;
    }
    /**
     * Get carriage value
     * @return \StructType\Carriage|null
     */
    public function getCarriage()
    {
        return $this->carriage;
    }
    /**
     * Set carriage value
     * @param \StructType\Carriage $carriage
     * @return \StructType\AddCarriage
     */
    public function setCarriage(\StructType\Carriage $carriage = null)
    {
        $this->carriage = $carriage;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\AddCarriage
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
