<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDocument StructType
 * @subpackage Structs
 */
class OrderDocument extends AbstractStructBase
{
    /**
     * The DocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocType;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The FileBody
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileBody;
    /**
     * Constructor method for OrderDocument
     * @uses OrderDocument::setDocType()
     * @uses OrderDocument::setFileName()
     * @uses OrderDocument::setFileBody()
     * @param int $docType
     * @param string $fileName
     * @param string $fileBody
     */
    public function __construct($docType = null, $fileName = null, $fileBody = null)
    {
        $this
            ->setDocType($docType)
            ->setFileName($fileName)
            ->setFileBody($fileBody);
    }
    /**
     * Get DocType value
     * @return int
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param int $docType
     * @return \StructType\OrderDocument
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: int
        if (!is_null($docType) && !(is_int($docType) || ctype_digit($docType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($docType, true), gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\OrderDocument
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get FileBody value
     * @return string|null
     */
    public function getFileBody()
    {
        return $this->FileBody;
    }
    /**
     * Set FileBody value
     * @param string $fileBody
     * @return \StructType\OrderDocument
     */
    public function setFileBody($fileBody = null)
    {
        // validation for constraint: string
        if (!is_null($fileBody) && !is_string($fileBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileBody, true), gettype($fileBody)), __LINE__);
        }
        $this->FileBody = $fileBody;
        return $this;
    }
}
