<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitialConfirmation StructType
 * @subpackage Structs
 */
class InitialConfirmation extends AbstractStructBase
{
    /**
     * The RequestId
     * Meta informations extracted from the WSDL
     * - maxLength: 13
     * - pattern: ^[0-9]\-[0-9]\-[0-9]$
     * @var string
     */
    public $RequestId;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxLength: 1
     * - pattern: ^[ES]{1}$
     * @var string
     */
    public $Type;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Errormessage
     */
    public $ErrorMessage;
    /**
     * The RequestDT
     * Meta informations extracted from the WSDL
     * - length: 8
     * - pattern: ^[0-9]$
     * @var string
     */
    public $RequestDT;
    /**
     * The RequestTM
     * Meta informations extracted from the WSDL
     * - length: 6
     * - pattern: ^[0-9]$
     * @var string
     */
    public $RequestTM;
    /**
     * Constructor method for InitialConfirmation
     * @uses InitialConfirmation::setRequestId()
     * @uses InitialConfirmation::setType()
     * @uses InitialConfirmation::setErrorMessage()
     * @uses InitialConfirmation::setRequestDT()
     * @uses InitialConfirmation::setRequestTM()
     * @param string $requestId
     * @param string $type
     * @param \StructType\Errormessage $errorMessage
     * @param string $requestDT
     * @param string $requestTM
     */
    public function __construct($requestId = null, $type = null, \StructType\Errormessage $errorMessage = null, $requestDT = null, $requestTM = null)
    {
        $this
            ->setRequestId($requestId)
            ->setType($type)
            ->setErrorMessage($errorMessage)
            ->setRequestDT($requestDT)
            ->setRequestTM($requestTM);
    }
    /**
     * Get RequestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param string $requestId
     * @return \StructType\InitialConfirmation
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestId) && strlen($requestId) > 13) || (is_array($requestId) && count($requestId) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($requestId) ? strlen($requestId) : count($requestId)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($requestId) && !preg_match('/^[0-9]\-[0-9]\-[0-9]$/', $requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[0-9]\-[0-9]\-[0-9]$", "%s" given', var_export($requestId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\InitialConfirmation
     */
    public function setType($type = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($type) && strlen($type) > 1) || (is_array($type) && count($type) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($type) ? strlen($type) : count($type)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($type) && !preg_match('/^[ES]{1}$/', $type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[ES]{1}$", "%s" given', var_export($type, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return \StructType\Errormessage|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param \StructType\Errormessage $errorMessage
     * @return \StructType\InitialConfirmation
     */
    public function setErrorMessage(\StructType\Errormessage $errorMessage = null)
    {
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get RequestDT value
     * @return string|null
     */
    public function getRequestDT()
    {
        return $this->RequestDT;
    }
    /**
     * Set RequestDT value
     * @param string $requestDT
     * @return \StructType\InitialConfirmation
     */
    public function setRequestDT($requestDT = null)
    {
        // validation for constraint: length
        if ((is_scalar($requestDT) && strlen($requestDT) !== 8) || (is_array($requestDT) && count($requestDT) !== 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($requestDT) && !preg_match('/^[0-9]$/', $requestDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[0-9]$", "%s" given', var_export($requestDT, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestDT) && !is_string($requestDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestDT)), __LINE__);
        }
        $this->RequestDT = $requestDT;
        return $this;
    }
    /**
     * Get RequestTM value
     * @return string|null
     */
    public function getRequestTM()
    {
        return $this->RequestTM;
    }
    /**
     * Set RequestTM value
     * @param string $requestTM
     * @return \StructType\InitialConfirmation
     */
    public function setRequestTM($requestTM = null)
    {
        // validation for constraint: length
        if ((is_scalar($requestTM) && strlen($requestTM) !== 6) || (is_array($requestTM) && count($requestTM) !== 6)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($requestTM) && !preg_match('/^[0-9]$/', $requestTM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[0-9]$", "%s" given', var_export($requestTM, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTM) && !is_string($requestTM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTM)), __LINE__);
        }
        $this->RequestTM = $requestTM;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InitialConfirmation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
