<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinalClosure StructType
 * @subpackage Structs
 */
class FinalClosure extends AbstractStructBase
{
    /**
     * The RequestId
     * Meta informations extracted from the WSDL
     * - maxLength: 13
     * - pattern: ^[0-9]\-[0-9]\-[0-9]$
     * @var string
     */
    public $RequestId;
    /**
     * The PdfDocument
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Pdfbinary
     */
    public $PdfDocument;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Zfctproditems
     */
    public $Products;
    /**
     * The uname
     * Meta informations extracted from the WSDL
     * - maxLength: 20
     * @var string
     */
    public $uname;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxLength: 70
     * @var string
     */
    public $name;
    /**
     * The ConsolidationDT
     * Meta informations extracted from the WSDL
     * - length: 8
     * - pattern: ^[0-9]$
     * @var string
     */
    public $ConsolidationDT;
    /**
     * Constructor method for FinalClosure
     * @uses FinalClosure::setRequestId()
     * @uses FinalClosure::setPdfDocument()
     * @uses FinalClosure::setProducts()
     * @uses FinalClosure::setUname()
     * @uses FinalClosure::setName()
     * @uses FinalClosure::setConsolidationDT()
     * @param string $requestId
     * @param \StructType\Pdfbinary $pdfDocument
     * @param \StructType\Zfctproditems $products
     * @param string $uname
     * @param string $name
     * @param string $consolidationDT
     */
    public function __construct($requestId = null, \StructType\Pdfbinary $pdfDocument = null, \StructType\Zfctproditems $products = null, $uname = null, $name = null, $consolidationDT = null)
    {
        $this
            ->setRequestId($requestId)
            ->setPdfDocument($pdfDocument)
            ->setProducts($products)
            ->setUname($uname)
            ->setName($name)
            ->setConsolidationDT($consolidationDT);
    }
    /**
     * Get RequestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param string $requestId
     * @return \StructType\FinalClosure
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestId) && strlen($requestId) > 13) || (is_array($requestId) && count($requestId) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($requestId) ? strlen($requestId) : count($requestId)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($requestId) && !preg_match('/^[0-9]\-[0-9]\-[0-9]$/', $requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[0-9]\-[0-9]\-[0-9]$", "%s" given', var_export($requestId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
    /**
     * Get PdfDocument value
     * @return \StructType\Pdfbinary|null
     */
    public function getPdfDocument()
    {
        return $this->PdfDocument;
    }
    /**
     * Set PdfDocument value
     * @param \StructType\Pdfbinary $pdfDocument
     * @return \StructType\FinalClosure
     */
    public function setPdfDocument(\StructType\Pdfbinary $pdfDocument = null)
    {
        $this->PdfDocument = $pdfDocument;
        return $this;
    }
    /**
     * Get Products value
     * @return \StructType\Zfctproditems|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \StructType\Zfctproditems $products
     * @return \StructType\FinalClosure
     */
    public function setProducts(\StructType\Zfctproditems $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get uname value
     * @return string|null
     */
    public function getUname()
    {
        return $this->uname;
    }
    /**
     * Set uname value
     * @param string $uname
     * @return \StructType\FinalClosure
     */
    public function setUname($uname = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uname) && strlen($uname) > 20) || (is_array($uname) && count($uname) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($uname) ? strlen($uname) : count($uname)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uname) && !is_string($uname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uname)), __LINE__);
        }
        $this->uname = $uname;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\FinalClosure
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 70) || (is_array($name) && count($name) > 70)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 70 element(s) or a scalar of 70 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ConsolidationDT value
     * @return string|null
     */
    public function getConsolidationDT()
    {
        return $this->ConsolidationDT;
    }
    /**
     * Set ConsolidationDT value
     * @param string $consolidationDT
     * @return \StructType\FinalClosure
     */
    public function setConsolidationDT($consolidationDT = null)
    {
        // validation for constraint: length
        if ((is_scalar($consolidationDT) && strlen($consolidationDT) !== 8) || (is_array($consolidationDT) && count($consolidationDT) !== 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($consolidationDT) && !preg_match('/^[0-9]$/', $consolidationDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[0-9]$", "%s" given', var_export($consolidationDT, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($consolidationDT) && !is_string($consolidationDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consolidationDT)), __LINE__);
        }
        $this->ConsolidationDT = $consolidationDT;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FinalClosure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
