<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for item StructType
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * - pattern: ^[ES]{1}$
     * @var string
     */
    public $Type;
    /**
     * The Class
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $Class;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 3
     * @var string
     */
    public $Number;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxLength: 220
     * @var string
     */
    public $Message;
    /**
     * The ZIDFCR
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $ZIDFCR;
    /**
     * The ZIDVER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 3
     * @var string
     */
    public $ZIDVER;
    /**
     * The MATNR
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 18
     * @var string
     */
    public $MATNR;
    /**
     * The PRODH
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 18
     * @var string
     */
    public $PRODH;
    /**
     * The ZMSUR
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 13
     * @var string
     */
    public $ZMSUR;
    /**
     * The ZMSUD
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 13
     * @var string
     */
    public $ZMSUD;
    /**
     * The ZMSUP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 13
     * @var string
     */
    public $ZMSUP;
    /**
     * The ZMSUO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 13
     * @var string
     */
    public $ZMSUO;
    /**
     * The MEINS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 4
     * @var string
     */
    public $MEINS;
    /**
     * The ZDTINP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $ZDTINP;
    /**
     * The ZDTINS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $ZDTINS;
    /**
     * The FROM_DEMAND
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $FROM_DEMAND;
    /**
     * The ZMSUR_FY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 13
     * @var string
     */
    public $ZMSUR_FY;
    /**
     * The ZMSUR_CO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 13
     * @var string
     */
    public $ZMSUR_CO;
    /**
     * The pdfBase64
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pdfBase64;
    /**
     * The pdfString
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pdfString;
    /**
     * The pdfHexBinary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pdfHexBinary;
    /**
     * Constructor method for item
     * @uses Item::setType()
     * @uses Item::setClass()
     * @uses Item::setNumber()
     * @uses Item::setMessage()
     * @uses Item::setZIDFCR()
     * @uses Item::setZIDVER()
     * @uses Item::setMATNR()
     * @uses Item::setPRODH()
     * @uses Item::setZMSUR()
     * @uses Item::setZMSUD()
     * @uses Item::setZMSUP()
     * @uses Item::setZMSUO()
     * @uses Item::setMEINS()
     * @uses Item::setZDTINP()
     * @uses Item::setZDTINS()
     * @uses Item::setFROM_DEMAND()
     * @uses Item::setZMSUR_FY()
     * @uses Item::setZMSUR_CO()
     * @uses Item::setPdfBase64()
     * @uses Item::setPdfString()
     * @uses Item::setPdfHexBinary()
     * @param string $type
     * @param string $class
     * @param string $number
     * @param string $message
     * @param string $zIDFCR
     * @param string $zIDVER
     * @param string $mATNR
     * @param string $pRODH
     * @param string $zMSUR
     * @param string $zMSUD
     * @param string $zMSUP
     * @param string $zMSUO
     * @param string $mEINS
     * @param string $zDTINP
     * @param string $zDTINS
     * @param string $fROM_DEMAND
     * @param string $zMSUR_FY
     * @param string $zMSUR_CO
     * @param string $pdfBase64
     * @param string $pdfString
     * @param string $pdfHexBinary
     */
    public function __construct($type = null, $class = null, $number = null, $message = null, $zIDFCR = null, $zIDVER = null, $mATNR = null, $pRODH = null, $zMSUR = null, $zMSUD = null, $zMSUP = null, $zMSUO = null, $mEINS = null, $zDTINP = null, $zDTINS = null, $fROM_DEMAND = null, $zMSUR_FY = null, $zMSUR_CO = null, $pdfBase64 = null, $pdfString = null, $pdfHexBinary = null)
    {
        $this
            ->setType($type)
            ->setClass($class)
            ->setNumber($number)
            ->setMessage($message)
            ->setZIDFCR($zIDFCR)
            ->setZIDVER($zIDVER)
            ->setMATNR($mATNR)
            ->setPRODH($pRODH)
            ->setZMSUR($zMSUR)
            ->setZMSUD($zMSUD)
            ->setZMSUP($zMSUP)
            ->setZMSUO($zMSUO)
            ->setMEINS($mEINS)
            ->setZDTINP($zDTINP)
            ->setZDTINS($zDTINS)
            ->setFROM_DEMAND($fROM_DEMAND)
            ->setZMSUR_FY($zMSUR_FY)
            ->setZMSUR_CO($zMSUR_CO)
            ->setPdfBase64($pdfBase64)
            ->setPdfString($pdfString)
            ->setPdfHexBinary($pdfHexBinary);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Item
     */
    public function setType($type = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($type) && strlen($type) > 1) || (is_array($type) && count($type) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($type) ? strlen($type) : count($type)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($type) && !preg_match('/^[ES]{1}$/', $type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "^[ES]{1}$", "%s" given', var_export($type, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param string $class
     * @return \StructType\Item
     */
    public function setClass($class = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($class) && strlen($class) > 20) || (is_array($class) && count($class) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($class) ? strlen($class) : count($class)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($class)), __LINE__);
        }
        $this->Class = $class;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\Item
     */
    public function setNumber($number = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($number) && strlen($number) > 3) || (is_array($number) && count($number) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($number) ? strlen($number) : count($number)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\Item
     */
    public function setMessage($message = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($message) && strlen($message) > 220) || (is_array($message) && count($message) > 220)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 220 element(s) or a scalar of 220 character(s) at most, "%d" length given', is_scalar($message) ? strlen($message) : count($message)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get ZIDFCR value
     * @return string|null
     */
    public function getZIDFCR()
    {
        return $this->ZIDFCR;
    }
    /**
     * Set ZIDFCR value
     * @param string $zIDFCR
     * @return \StructType\Item
     */
    public function setZIDFCR($zIDFCR = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zIDFCR) && strlen($zIDFCR) > 8) || (is_array($zIDFCR) && count($zIDFCR) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($zIDFCR) ? strlen($zIDFCR) : count($zIDFCR)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zIDFCR) && !is_string($zIDFCR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zIDFCR)), __LINE__);
        }
        $this->ZIDFCR = $zIDFCR;
        return $this;
    }
    /**
     * Get ZIDVER value
     * @return string|null
     */
    public function getZIDVER()
    {
        return $this->ZIDVER;
    }
    /**
     * Set ZIDVER value
     * @param string $zIDVER
     * @return \StructType\Item
     */
    public function setZIDVER($zIDVER = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zIDVER) && strlen($zIDVER) > 3) || (is_array($zIDVER) && count($zIDVER) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($zIDVER) ? strlen($zIDVER) : count($zIDVER)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zIDVER) && !is_string($zIDVER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zIDVER)), __LINE__);
        }
        $this->ZIDVER = $zIDVER;
        return $this;
    }
    /**
     * Get MATNR value
     * @return string|null
     */
    public function getMATNR()
    {
        return $this->MATNR;
    }
    /**
     * Set MATNR value
     * @param string $mATNR
     * @return \StructType\Item
     */
    public function setMATNR($mATNR = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mATNR) && strlen($mATNR) > 18) || (is_array($mATNR) && count($mATNR) > 18)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 18 element(s) or a scalar of 18 character(s) at most, "%d" length given', is_scalar($mATNR) ? strlen($mATNR) : count($mATNR)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mATNR) && !is_string($mATNR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mATNR)), __LINE__);
        }
        $this->MATNR = $mATNR;
        return $this;
    }
    /**
     * Get PRODH value
     * @return string|null
     */
    public function getPRODH()
    {
        return $this->PRODH;
    }
    /**
     * Set PRODH value
     * @param string $pRODH
     * @return \StructType\Item
     */
    public function setPRODH($pRODH = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pRODH) && strlen($pRODH) > 18) || (is_array($pRODH) && count($pRODH) > 18)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 18 element(s) or a scalar of 18 character(s) at most, "%d" length given', is_scalar($pRODH) ? strlen($pRODH) : count($pRODH)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pRODH) && !is_string($pRODH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pRODH)), __LINE__);
        }
        $this->PRODH = $pRODH;
        return $this;
    }
    /**
     * Get ZMSUR value
     * @return string|null
     */
    public function getZMSUR()
    {
        return $this->ZMSUR;
    }
    /**
     * Set ZMSUR value
     * @param string $zMSUR
     * @return \StructType\Item
     */
    public function setZMSUR($zMSUR = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zMSUR) && strlen($zMSUR) > 13) || (is_array($zMSUR) && count($zMSUR) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($zMSUR) ? strlen($zMSUR) : count($zMSUR)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zMSUR) && !is_string($zMSUR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zMSUR)), __LINE__);
        }
        $this->ZMSUR = $zMSUR;
        return $this;
    }
    /**
     * Get ZMSUD value
     * @return string|null
     */
    public function getZMSUD()
    {
        return $this->ZMSUD;
    }
    /**
     * Set ZMSUD value
     * @param string $zMSUD
     * @return \StructType\Item
     */
    public function setZMSUD($zMSUD = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zMSUD) && strlen($zMSUD) > 13) || (is_array($zMSUD) && count($zMSUD) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($zMSUD) ? strlen($zMSUD) : count($zMSUD)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zMSUD) && !is_string($zMSUD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zMSUD)), __LINE__);
        }
        $this->ZMSUD = $zMSUD;
        return $this;
    }
    /**
     * Get ZMSUP value
     * @return string|null
     */
    public function getZMSUP()
    {
        return $this->ZMSUP;
    }
    /**
     * Set ZMSUP value
     * @param string $zMSUP
     * @return \StructType\Item
     */
    public function setZMSUP($zMSUP = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zMSUP) && strlen($zMSUP) > 13) || (is_array($zMSUP) && count($zMSUP) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($zMSUP) ? strlen($zMSUP) : count($zMSUP)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zMSUP) && !is_string($zMSUP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zMSUP)), __LINE__);
        }
        $this->ZMSUP = $zMSUP;
        return $this;
    }
    /**
     * Get ZMSUO value
     * @return string|null
     */
    public function getZMSUO()
    {
        return $this->ZMSUO;
    }
    /**
     * Set ZMSUO value
     * @param string $zMSUO
     * @return \StructType\Item
     */
    public function setZMSUO($zMSUO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zMSUO) && strlen($zMSUO) > 13) || (is_array($zMSUO) && count($zMSUO) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($zMSUO) ? strlen($zMSUO) : count($zMSUO)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zMSUO) && !is_string($zMSUO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zMSUO)), __LINE__);
        }
        $this->ZMSUO = $zMSUO;
        return $this;
    }
    /**
     * Get MEINS value
     * @return string|null
     */
    public function getMEINS()
    {
        return $this->MEINS;
    }
    /**
     * Set MEINS value
     * @param string $mEINS
     * @return \StructType\Item
     */
    public function setMEINS($mEINS = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mEINS) && strlen($mEINS) > 4) || (is_array($mEINS) && count($mEINS) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($mEINS) ? strlen($mEINS) : count($mEINS)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mEINS) && !is_string($mEINS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mEINS)), __LINE__);
        }
        $this->MEINS = $mEINS;
        return $this;
    }
    /**
     * Get ZDTINP value
     * @return string|null
     */
    public function getZDTINP()
    {
        return $this->ZDTINP;
    }
    /**
     * Set ZDTINP value
     * @param string $zDTINP
     * @return \StructType\Item
     */
    public function setZDTINP($zDTINP = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zDTINP) && strlen($zDTINP) > 8) || (is_array($zDTINP) && count($zDTINP) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($zDTINP) ? strlen($zDTINP) : count($zDTINP)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zDTINP) && !is_string($zDTINP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zDTINP)), __LINE__);
        }
        $this->ZDTINP = $zDTINP;
        return $this;
    }
    /**
     * Get ZDTINS value
     * @return string|null
     */
    public function getZDTINS()
    {
        return $this->ZDTINS;
    }
    /**
     * Set ZDTINS value
     * @param string $zDTINS
     * @return \StructType\Item
     */
    public function setZDTINS($zDTINS = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zDTINS) && strlen($zDTINS) > 8) || (is_array($zDTINS) && count($zDTINS) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($zDTINS) ? strlen($zDTINS) : count($zDTINS)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zDTINS) && !is_string($zDTINS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zDTINS)), __LINE__);
        }
        $this->ZDTINS = $zDTINS;
        return $this;
    }
    /**
     * Get FROM_DEMAND value
     * @return string|null
     */
    public function getFROM_DEMAND()
    {
        return $this->FROM_DEMAND;
    }
    /**
     * Set FROM_DEMAND value
     * @param string $fROM_DEMAND
     * @return \StructType\Item
     */
    public function setFROM_DEMAND($fROM_DEMAND = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fROM_DEMAND) && strlen($fROM_DEMAND) > 1) || (is_array($fROM_DEMAND) && count($fROM_DEMAND) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($fROM_DEMAND) ? strlen($fROM_DEMAND) : count($fROM_DEMAND)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fROM_DEMAND) && !is_string($fROM_DEMAND)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fROM_DEMAND)), __LINE__);
        }
        $this->FROM_DEMAND = $fROM_DEMAND;
        return $this;
    }
    /**
     * Get ZMSUR_FY value
     * @return string|null
     */
    public function getZMSUR_FY()
    {
        return $this->ZMSUR_FY;
    }
    /**
     * Set ZMSUR_FY value
     * @param string $zMSUR_FY
     * @return \StructType\Item
     */
    public function setZMSUR_FY($zMSUR_FY = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zMSUR_FY) && strlen($zMSUR_FY) > 13) || (is_array($zMSUR_FY) && count($zMSUR_FY) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($zMSUR_FY) ? strlen($zMSUR_FY) : count($zMSUR_FY)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zMSUR_FY) && !is_string($zMSUR_FY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zMSUR_FY)), __LINE__);
        }
        $this->ZMSUR_FY = $zMSUR_FY;
        return $this;
    }
    /**
     * Get ZMSUR_CO value
     * @return string|null
     */
    public function getZMSUR_CO()
    {
        return $this->ZMSUR_CO;
    }
    /**
     * Set ZMSUR_CO value
     * @param string $zMSUR_CO
     * @return \StructType\Item
     */
    public function setZMSUR_CO($zMSUR_CO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zMSUR_CO) && strlen($zMSUR_CO) > 13) || (is_array($zMSUR_CO) && count($zMSUR_CO) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($zMSUR_CO) ? strlen($zMSUR_CO) : count($zMSUR_CO)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zMSUR_CO) && !is_string($zMSUR_CO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zMSUR_CO)), __LINE__);
        }
        $this->ZMSUR_CO = $zMSUR_CO;
        return $this;
    }
    /**
     * Get pdfBase64 value
     * @return string|null
     */
    public function getPdfBase64()
    {
        return $this->pdfBase64;
    }
    /**
     * Set pdfBase64 value
     * @param string $pdfBase64
     * @return \StructType\Item
     */
    public function setPdfBase64($pdfBase64 = null)
    {
        // validation for constraint: string
        if (!is_null($pdfBase64) && !is_string($pdfBase64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pdfBase64)), __LINE__);
        }
        $this->pdfBase64 = $pdfBase64;
        return $this;
    }
    /**
     * Get pdfString value
     * @return string|null
     */
    public function getPdfString()
    {
        return $this->pdfString;
    }
    /**
     * Set pdfString value
     * @param string $pdfString
     * @return \StructType\Item
     */
    public function setPdfString($pdfString = null)
    {
        // validation for constraint: string
        if (!is_null($pdfString) && !is_string($pdfString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pdfString)), __LINE__);
        }
        $this->pdfString = $pdfString;
        return $this;
    }
    /**
     * Get pdfHexBinary value
     * @return string|null
     */
    public function getPdfHexBinary()
    {
        return $this->pdfHexBinary;
    }
    /**
     * Set pdfHexBinary value
     * @param string $pdfHexBinary
     * @return \StructType\Item
     */
    public function setPdfHexBinary($pdfHexBinary = null)
    {
        // validation for constraint: string
        if (!is_null($pdfHexBinary) && !is_string($pdfHexBinary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pdfHexBinary)), __LINE__);
        }
        $this->pdfHexBinary = $pdfHexBinary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
