<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Final ServiceType
 * @subpackage Services
 */
class _Final extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FinalClosure
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FinalClosure $finalClosure_msg
     * @return void|bool
     */
    public function FinalClosure(\StructType\FinalClosure $finalClosure_msg)
    {
        try {
            $this->setResult(self::getSoapClient()->FinalClosure($finalClosure_msg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
