<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Site ServiceType
 * @subpackage Services
 */
class Site extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SiteSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiteSearch $search
     * @return \StructType\SiteList|bool
     */
    public function SiteSearch(\StructType\SiteSearch $search)
    {
        try {
            $this->setResult($this->getSoapClient()->SiteSearch($search));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiteAdd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Site $item
     * @return \StructType\SiteResult|bool
     */
    public function SiteAdd(\StructType\Site $item)
    {
        try {
            $this->setResult($this->getSoapClient()->SiteAdd($item));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiteChange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Site $item
     * @return \StructType\SiteResult|bool
     */
    public function SiteChange(\StructType\Site $item)
    {
        try {
            $this->setResult($this->getSoapClient()->SiteChange($item));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiteRemove
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Site $item
     * @return \StructType\Status|bool
     */
    public function SiteRemove(\StructType\Site $item)
    {
        try {
            $this->setResult($this->getSoapClient()->SiteRemove($item));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SiteList|\StructType\SiteResult|\StructType\Status
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
