<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Configuration StructType
 * @subpackage Structs
 */
class Configuration extends AbstractStructBase
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - choice: Error | SiteResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ErrorInfo
     */
    public $Error;
    /**
     * The SiteResult
     * Meta information extracted from the WSDL
     * - choice: Error | SiteResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SiteResult[]
     */
    public $SiteResult;
    /**
     * Constructor method for Configuration
     * @uses Configuration::setError()
     * @uses Configuration::setSiteResult()
     * @param \StructType\ErrorInfo $error
     * @param \StructType\SiteResult[] $siteResult
     */
    public function __construct(\StructType\ErrorInfo $error = null, array $siteResult = array())
    {
        $this
            ->setError($error)
            ->setSiteResult($siteResult);
    }
    /**
     * Get Error value
     * @return \StructType\ErrorInfo|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * This method is responsible for validating the value passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorForChoiceConstraintsFromSetError($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SiteResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Error can\'t be set as the property %s is already set. Only one property must be set among these properties: Error, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Error value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorInfo $error
     * @return \StructType\Configuration
     */
    public function setError(\StructType\ErrorInfo $error = null)
    {
        // validation for constraint: choice(Error, SiteResult)
        if ('' !== ($errorChoiceErrorMessage = self::validateErrorForChoiceConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorChoiceErrorMessage, __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get SiteResult value
     * @return \StructType\SiteResult[]|null
     */
    public function getSiteResult()
    {
        return isset($this->SiteResult) ? $this->SiteResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSiteResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSiteResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSiteResultForArrayConstraintsFromSetSiteResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $configurationSiteResultItem) {
            // validation for constraint: itemType
            if (!$configurationSiteResultItem instanceof \StructType\SiteResult) {
                $invalidValues[] = is_object($configurationSiteResultItem) ? get_class($configurationSiteResultItem) : sprintf('%s(%s)', gettype($configurationSiteResultItem), var_export($configurationSiteResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SiteResult property can only contain items of type \StructType\SiteResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setSiteResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSiteResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSiteResultForChoiceConstraintsFromSetSiteResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Error',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SiteResult can\'t be set as the property %s is already set. Only one property must be set among these properties: SiteResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SiteResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\SiteResult[] $siteResult
     * @return \StructType\Configuration
     */
    public function setSiteResult(array $siteResult = array())
    {
        // validation for constraint: array
        if ('' !== ($siteResultArrayErrorMessage = self::validateSiteResultForArrayConstraintsFromSetSiteResult($siteResult))) {
            throw new \InvalidArgumentException($siteResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Error, SiteResult)
        if ('' !== ($siteResultChoiceErrorMessage = self::validateSiteResultForChoiceConstraintsFromSetSiteResult($siteResult))) {
            throw new \InvalidArgumentException($siteResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($siteResult) || (is_array($siteResult) && empty($siteResult))) {
            unset($this->SiteResult);
        } else {
            $this->SiteResult = $siteResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToSiteResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToSiteResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToSiteResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Error',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SiteResult can\'t be set as the property %s is already set. Only one property must be set among these properties: SiteResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to SiteResult value
     * @throws \InvalidArgumentException
     * @param \StructType\SiteResult $item
     * @return \StructType\Configuration
     */
    public function addToSiteResult(\StructType\SiteResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SiteResult) {
            throw new \InvalidArgumentException(sprintf('The SiteResult property can only contain items of type \StructType\SiteResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Error, SiteResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToSiteResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->SiteResult[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Configuration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
