<?php

namespace warranty_soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationHeader StructType
 * Meta information extracted from the WSDL
 * - type: tns:AuthenticationHeader
 * @subpackage Structs
 */
class AuthenticationHeader extends AbstractStructBase
{
    /**
     * The authCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authCode;
    /**
     * Constructor method for AuthenticationHeader
     * @uses AuthenticationHeader::setAuthCode()
     * @param string $authCode
     */
    public function __construct($authCode = null)
    {
        $this
            ->setAuthCode($authCode);
    }
    /**
     * Get authCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->authCode;
    }
    /**
     * Set authCode value
     * @param string $authCode
     * @return \warranty_soap\StructType\AuthenticationHeader
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->authCode = $authCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \warranty_soap\StructType\AuthenticationHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
