<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateAfdelingRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Wijzigen van de gegevens van een afdeling bij een bedrijf <br/><u>Let op:</u> bij wijzigingen van een bestaande afdeling dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen worden
 * leeg gemaakt door de update.
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class UpdateAfdelingRequest extends AbstractStructBase
{
    /**
     * The afdeling
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de afdeling
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \RelatieApiV3\StructType\AfdelingRecV3
     */
    public $afdeling;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for updateAfdelingRequest
     * @uses UpdateAfdelingRequest::setAfdeling()
     * @uses UpdateAfdelingRequest::setRequestTag()
     * @param \RelatieApiV3\StructType\AfdelingRecV3 $afdeling
     * @param string $requestTag
     */
    public function __construct(\RelatieApiV3\StructType\AfdelingRecV3 $afdeling = null, $requestTag = null)
    {
        $this
            ->setAfdeling($afdeling)
            ->setRequestTag($requestTag);
    }
    /**
     * Get afdeling value
     * @return \RelatieApiV3\StructType\AfdelingRecV3
     */
    public function getAfdeling()
    {
        return $this->afdeling;
    }
    /**
     * Set afdeling value
     * @param \RelatieApiV3\StructType\AfdelingRecV3 $afdeling
     * @return \RelatieApiV3\StructType\UpdateAfdelingRequest
     */
    public function setAfdeling(\RelatieApiV3\StructType\AfdelingRecV3 $afdeling = null)
    {
        $this->afdeling = $afdeling;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\UpdateAfdelingRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\UpdateAfdelingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
