<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchNaamTableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met Relatiegegevens, tbv de SearchNaam operatie
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class SearchNaamTableV3 extends AbstractStructBase
{
    /**
     * The searchNaamRecV3
     * Meta information extracted from the WSDL
     * - documentation: relatiegegevens
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\SearchNaamRecV3[]
     */
    public $searchNaamRecV3;
    /**
     * Constructor method for SearchNaamTableV3
     * @uses SearchNaamTableV3::setSearchNaamRecV3()
     * @param \RelatieApiV3\StructType\SearchNaamRecV3[] $searchNaamRecV3
     */
    public function __construct(array $searchNaamRecV3 = array())
    {
        $this
            ->setSearchNaamRecV3($searchNaamRecV3);
    }
    /**
     * Get searchNaamRecV3 value
     * @return \RelatieApiV3\StructType\SearchNaamRecV3[]|null
     */
    public function getSearchNaamRecV3()
    {
        return $this->searchNaamRecV3;
    }
    /**
     * This method is responsible for validating the values passed to the setSearchNaamRecV3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSearchNaamRecV3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSearchNaamRecV3ForArrayConstraintsFromSetSearchNaamRecV3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchNaamTableV3SearchNaamRecV3Item) {
            // validation for constraint: itemType
            if (!$searchNaamTableV3SearchNaamRecV3Item instanceof \RelatieApiV3\StructType\SearchNaamRecV3) {
                $invalidValues[] = is_object($searchNaamTableV3SearchNaamRecV3Item) ? get_class($searchNaamTableV3SearchNaamRecV3Item) : sprintf('%s(%s)', gettype($searchNaamTableV3SearchNaamRecV3Item), var_export($searchNaamTableV3SearchNaamRecV3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The searchNaamRecV3 property can only contain items of type \RelatieApiV3\StructType\SearchNaamRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set searchNaamRecV3 value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\SearchNaamRecV3[] $searchNaamRecV3
     * @return \RelatieApiV3\StructType\SearchNaamTableV3
     */
    public function setSearchNaamRecV3(array $searchNaamRecV3 = array())
    {
        // validation for constraint: array
        if ('' !== ($searchNaamRecV3ArrayErrorMessage = self::validateSearchNaamRecV3ForArrayConstraintsFromSetSearchNaamRecV3($searchNaamRecV3))) {
            throw new \InvalidArgumentException($searchNaamRecV3ArrayErrorMessage, __LINE__);
        }
        $this->searchNaamRecV3 = $searchNaamRecV3;
        return $this;
    }
    /**
     * Add item to searchNaamRecV3 value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\SearchNaamRecV3 $item
     * @return \RelatieApiV3\StructType\SearchNaamTableV3
     */
    public function addToSearchNaamRecV3(\RelatieApiV3\StructType\SearchNaamRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\SearchNaamRecV3) {
            throw new \InvalidArgumentException(sprintf('The searchNaamRecV3 property can only contain items of type \RelatieApiV3\StructType\SearchNaamRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->searchNaamRecV3[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\SearchNaamTableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
