<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchNaamRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Zoeken naar relaties op basis van de naam
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class SearchNaamRequest extends AbstractStructBase
{
    /**
     * The zoekVoorwaarde
     * Meta information extracted from the WSDL
     * - documentation: De zoekvoorwaarde waarop relaties gezocht moet worden
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $zoekVoorwaarde;
    /**
     * The zoekMethode
     * Meta information extracted from the WSDL
     * - documentation: Soort zoekmethode. Mogelijkheden: <ul> <li>GELIJK AAN: complete naam moet gelijk zijn aan de opgegeven zoekvoorwaarde</li> <li>BEGINT MET: de naam moet beginnen met de opgegeven zoekvoorwaarde</li> <li>BEVAT: de naam moet de
     * opgegeven zoekvoorwaarde bevatten (let op: deze methode kan lang duren!)</li> </ul>
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $zoekMethode;
    /**
     * The caseSensitive
     * Meta information extracted from the WSDL
     * - documentation: Indien true is zoeken hoofdlettergevoelig.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $caseSensitive;
    /**
     * The alleenAdverteerders
     * Meta information extracted from the WSDL
     * - documentation: Indien true, alleen relaties teruggeven die als adverteerder zijn aangegeven.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $alleenAdverteerders;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij.<br> De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relatieType
     * Meta information extracted from the WSDL
     * - documentation: {B,A,P,C} Indien opgegeven: alleen relaties zoeken van een bepaalde relatieType. B = Bedrijf, A = Afdeling, P = Persoon, C = Contactpersoon en leeg betekent alle relatieTypen. Let op: indien geen relatieType is meegegeven kan de
     * operatie lang duren.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relatieType;
    /**
     * Constructor method for searchNaamRequest
     * @uses SearchNaamRequest::setZoekVoorwaarde()
     * @uses SearchNaamRequest::setZoekMethode()
     * @uses SearchNaamRequest::setCaseSensitive()
     * @uses SearchNaamRequest::setAlleenAdverteerders()
     * @uses SearchNaamRequest::setRequestTag()
     * @uses SearchNaamRequest::setRelatieType()
     * @param string $zoekVoorwaarde
     * @param string $zoekMethode
     * @param bool $caseSensitive
     * @param bool $alleenAdverteerders
     * @param string $requestTag
     * @param string $relatieType
     */
    public function __construct($zoekVoorwaarde = null, $zoekMethode = null, $caseSensitive = null, $alleenAdverteerders = null, $requestTag = null, $relatieType = null)
    {
        $this
            ->setZoekVoorwaarde($zoekVoorwaarde)
            ->setZoekMethode($zoekMethode)
            ->setCaseSensitive($caseSensitive)
            ->setAlleenAdverteerders($alleenAdverteerders)
            ->setRequestTag($requestTag)
            ->setRelatieType($relatieType);
    }
    /**
     * Get zoekVoorwaarde value
     * @return string
     */
    public function getZoekVoorwaarde()
    {
        return $this->zoekVoorwaarde;
    }
    /**
     * Set zoekVoorwaarde value
     * @param string $zoekVoorwaarde
     * @return \RelatieApiV3\StructType\SearchNaamRequest
     */
    public function setZoekVoorwaarde($zoekVoorwaarde = null)
    {
        // validation for constraint: string
        if (!is_null($zoekVoorwaarde) && !is_string($zoekVoorwaarde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zoekVoorwaarde, true), gettype($zoekVoorwaarde)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($zoekVoorwaarde) && mb_strlen($zoekVoorwaarde) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($zoekVoorwaarde)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($zoekVoorwaarde) && mb_strlen($zoekVoorwaarde) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($zoekVoorwaarde)), __LINE__);
        }
        $this->zoekVoorwaarde = $zoekVoorwaarde;
        return $this;
    }
    /**
     * Get zoekMethode value
     * @return string
     */
    public function getZoekMethode()
    {
        return $this->zoekMethode;
    }
    /**
     * Set zoekMethode value
     * @param string $zoekMethode
     * @return \RelatieApiV3\StructType\SearchNaamRequest
     */
    public function setZoekMethode($zoekMethode = null)
    {
        // validation for constraint: string
        if (!is_null($zoekMethode) && !is_string($zoekMethode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zoekMethode, true), gettype($zoekMethode)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($zoekMethode) && mb_strlen($zoekMethode) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($zoekMethode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($zoekMethode) && mb_strlen($zoekMethode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($zoekMethode)), __LINE__);
        }
        $this->zoekMethode = $zoekMethode;
        return $this;
    }
    /**
     * Get caseSensitive value
     * @return bool
     */
    public function getCaseSensitive()
    {
        return $this->caseSensitive;
    }
    /**
     * Set caseSensitive value
     * @param bool $caseSensitive
     * @return \RelatieApiV3\StructType\SearchNaamRequest
     */
    public function setCaseSensitive($caseSensitive = null)
    {
        // validation for constraint: boolean
        if (!is_null($caseSensitive) && !is_bool($caseSensitive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($caseSensitive, true), gettype($caseSensitive)), __LINE__);
        }
        $this->caseSensitive = $caseSensitive;
        return $this;
    }
    /**
     * Get alleenAdverteerders value
     * @return bool
     */
    public function getAlleenAdverteerders()
    {
        return $this->alleenAdverteerders;
    }
    /**
     * Set alleenAdverteerders value
     * @param bool $alleenAdverteerders
     * @return \RelatieApiV3\StructType\SearchNaamRequest
     */
    public function setAlleenAdverteerders($alleenAdverteerders = null)
    {
        // validation for constraint: boolean
        if (!is_null($alleenAdverteerders) && !is_bool($alleenAdverteerders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alleenAdverteerders, true), gettype($alleenAdverteerders)), __LINE__);
        }
        $this->alleenAdverteerders = $alleenAdverteerders;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV3\StructType\SearchNaamRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relatieType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatieType()
    {
        return isset($this->relatieType) ? $this->relatieType : null;
    }
    /**
     * Set relatieType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatieType
     * @return \RelatieApiV3\StructType\SearchNaamRequest
     */
    public function setRelatieType($relatieType = null)
    {
        // validation for constraint: string
        if (!is_null($relatieType) && !is_string($relatieType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatieType, true), gettype($relatieType)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($relatieType) && mb_strlen($relatieType) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($relatieType)), __LINE__);
        }
        if (is_null($relatieType) || (is_array($relatieType) && empty($relatieType))) {
            unset($this->relatieType);
        } else {
            $this->relatieType = $relatieType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\SearchNaamRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
