<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatienrRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Relatienummers
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class RelatienrRecV3 extends AbstractStructBase
{
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummer;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - documentation: De status van het e-mail adres. <br/> 1= Relatie bekend echter zonder username (geen user)<br/> 2= Relatie bekend met username (user bekend).
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 1
     * @var int
     */
    public $status;
    /**
     * The relatietype
     * Meta information extracted from the WSDL
     * - documentation: Het relatietype ( 'B'(edrijf), 'A'(fdeling), 'C'(ontactpersoon), 'P'(private persoon), (Bedrijf) 'I' (nclusief contactpersoon))
     * - base: xsd:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relatietype;
    /**
     * Constructor method for RelatienrRecV3
     * @uses RelatienrRecV3::setRelatienummer()
     * @uses RelatienrRecV3::setStatus()
     * @uses RelatienrRecV3::setRelatietype()
     * @param int $relatienummer
     * @param int $status
     * @param string $relatietype
     */
    public function __construct($relatienummer = null, $status = null, $relatietype = null)
    {
        $this
            ->setRelatienummer($relatienummer)
            ->setStatus($status)
            ->setRelatietype($relatietype);
    }
    /**
     * Get relatienummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummer()
    {
        return isset($this->relatienummer) ? $this->relatienummer : null;
    }
    /**
     * Set relatienummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummer
     * @return \RelatieApiV3\StructType\RelatienrRecV3
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummer) && !(is_int($relatienummer) || ctype_digit($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        if (is_null($relatienummer) || (is_array($relatienummer) && empty($relatienummer))) {
            unset($this->relatienummer);
        } else {
            $this->relatienummer = $relatienummer;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $status
     * @return \RelatieApiV3\StructType\RelatienrRecV3
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($status) && mb_strlen(preg_replace('/(\D)/', '', $status)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($status, true), mb_strlen(preg_replace('/(\D)/', '', $status))), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get relatietype value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatietype()
    {
        return isset($this->relatietype) ? $this->relatietype : null;
    }
    /**
     * Set relatietype value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatietype
     * @return \RelatieApiV3\StructType\RelatienrRecV3
     */
    public function setRelatietype($relatietype = null)
    {
        // validation for constraint: string
        if (!is_null($relatietype) && !is_string($relatietype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatietype, true), gettype($relatietype)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($relatietype) && mb_strlen($relatietype) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($relatietype)), __LINE__);
        }
        if (is_null($relatietype) || (is_array($relatietype) && empty($relatietype))) {
            unset($this->relatietype);
        } else {
            $this->relatietype = $relatietype;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\RelatienrRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
