<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieKortinggroepRecV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Relatie kortinggroep
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class RelatieKortinggroepRecV3 extends AbstractStructBase
{
    /**
     * The kortinggroepCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de relatie kortinggroep
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kortinggroepCode;
    /**
     * The kortinggroepOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de relatie kortinggroep
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortinggroepOmschrijving;
    /**
     * Constructor method for RelatieKortinggroepRecV3
     * @uses RelatieKortinggroepRecV3::setKortinggroepCode()
     * @uses RelatieKortinggroepRecV3::setKortinggroepOmschrijving()
     * @param string $kortinggroepCode
     * @param string $kortinggroepOmschrijving
     */
    public function __construct($kortinggroepCode = null, $kortinggroepOmschrijving = null)
    {
        $this
            ->setKortinggroepCode($kortinggroepCode)
            ->setKortinggroepOmschrijving($kortinggroepOmschrijving);
    }
    /**
     * Get kortinggroepCode value
     * @return string
     */
    public function getKortinggroepCode()
    {
        return $this->kortinggroepCode;
    }
    /**
     * Set kortinggroepCode value
     * @param string $kortinggroepCode
     * @return \RelatieApiV3\StructType\RelatieKortinggroepRecV3
     */
    public function setKortinggroepCode($kortinggroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($kortinggroepCode) && !is_string($kortinggroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortinggroepCode, true), gettype($kortinggroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kortinggroepCode) && mb_strlen($kortinggroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kortinggroepCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kortinggroepCode) && mb_strlen($kortinggroepCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kortinggroepCode)), __LINE__);
        }
        $this->kortinggroepCode = $kortinggroepCode;
        return $this;
    }
    /**
     * Get kortinggroepOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortinggroepOmschrijving()
    {
        return isset($this->kortinggroepOmschrijving) ? $this->kortinggroepOmschrijving : null;
    }
    /**
     * Set kortinggroepOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortinggroepOmschrijving
     * @return \RelatieApiV3\StructType\RelatieKortinggroepRecV3
     */
    public function setKortinggroepOmschrijving($kortinggroepOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($kortinggroepOmschrijving) && !is_string($kortinggroepOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortinggroepOmschrijving, true), gettype($kortinggroepOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($kortinggroepOmschrijving) && mb_strlen($kortinggroepOmschrijving) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($kortinggroepOmschrijving)), __LINE__);
        }
        if (is_null($kortinggroepOmschrijving) || (is_array($kortinggroepOmschrijving) && empty($kortinggroepOmschrijving))) {
            unset($this->kortinggroepOmschrijving);
        } else {
            $this->kortinggroepOmschrijving = $kortinggroepOmschrijving;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\RelatieKortinggroepRecV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
