<?php

namespace RelatieApiV3\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersoontableV3 StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met personen
 * @subpackage Structs
 * @date 20200204
 * @package RelatieApiV3
 */
class PersoontableV3 extends AbstractStructBase
{
    /**
     * The persoon
     * Meta information extracted from the WSDL
     * - documentation: personen
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV3\StructType\PersooninfoRecV3[]
     */
    public $persoon;
    /**
     * Constructor method for PersoontableV3
     * @uses PersoontableV3::setPersoon()
     * @param \RelatieApiV3\StructType\PersooninfoRecV3[] $persoon
     */
    public function __construct(array $persoon = array())
    {
        $this
            ->setPersoon($persoon);
    }
    /**
     * Get persoon value
     * @return \RelatieApiV3\StructType\PersooninfoRecV3[]|null
     */
    public function getPersoon()
    {
        return $this->persoon;
    }
    /**
     * This method is responsible for validating the values passed to the setPersoon method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersoon method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersoonForArrayConstraintsFromSetPersoon(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $persoontableV3PersoonItem) {
            // validation for constraint: itemType
            if (!$persoontableV3PersoonItem instanceof \RelatieApiV3\StructType\PersooninfoRecV3) {
                $invalidValues[] = is_object($persoontableV3PersoonItem) ? get_class($persoontableV3PersoonItem) : sprintf('%s(%s)', gettype($persoontableV3PersoonItem), var_export($persoontableV3PersoonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The persoon property can only contain items of type \RelatieApiV3\StructType\PersooninfoRecV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set persoon value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\PersooninfoRecV3[] $persoon
     * @return \RelatieApiV3\StructType\PersoontableV3
     */
    public function setPersoon(array $persoon = array())
    {
        // validation for constraint: array
        if ('' !== ($persoonArrayErrorMessage = self::validatePersoonForArrayConstraintsFromSetPersoon($persoon))) {
            throw new \InvalidArgumentException($persoonArrayErrorMessage, __LINE__);
        }
        $this->persoon = $persoon;
        return $this;
    }
    /**
     * Add item to persoon value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV3\StructType\PersooninfoRecV3 $item
     * @return \RelatieApiV3\StructType\PersoontableV3
     */
    public function addToPersoon(\RelatieApiV3\StructType\PersooninfoRecV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV3\StructType\PersooninfoRecV3) {
            throw new \InvalidArgumentException(sprintf('The persoon property can only contain items of type \RelatieApiV3\StructType\PersooninfoRecV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->persoon[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \RelatieApiV3\StructType\PersoontableV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
